/// <reference types="react" />
import Component from '../AbstractComponent';
import { StyleProp, ViewStyle } from 'react-native';
export interface ToastProps {
    msg?: string;
    show?: boolean;
    containerStyle?: StyleProp<ViewStyle>;
    contentStyle?: StyleProp<ViewStyle>;
}
export declare class Toast extends Component<ToastProps> {
    static defaultProps: {
        children: string;
        show: boolean;
    };
    state: {};
    showAnimation: {
        animation: string;
        duration: number;
    };
    hideAnimation: {
        animation: string;
        duration: number;
    };
    render(): JSX.Element;
}
export declare const SHORT: number;
export declare const LONG: number;
/**
 * 显示一个默认的toast弹框
 * @param msg 问题消息
 * @param duration 持续时间
 */
export default function show(msg: any, duration?: any): void;
/**
 * 使用自定义UI的toast
 */
export declare function toast({duration, ...props}?: any): void;
/**
 * 设置关闭时间
 * @param duration 关闭时间,毫秒
 */
export declare function setDuration(duration: any): void;
