const timeoutMilliSec = 90000;
export function createReducer(initialState, reducerMap) {
  return (state = initialState, action) => {
    const reducer = reducerMap[action.type];
    if (typeof(action) === 'undefined') {
        console.error('Invalid action in utils/index');
        return;
    }
    return reducer ? reducer(state, action.payload) : state;
  };
}

export function bindListener(listener,action) {
    let prevState = {};
    return listener(newState => {
        if(prevState === newState) return;
        prevState = newState;
        action(newState);
    });
}

export function delay(ms, promise) {
    let p = new Promise(function (resolve, _){
        promise.then((value) => {
            setTimeout(resolve, ms, value);
        });
    });
    return p;
}


/*WAIT AND CHECK FOR A VALUE*/
export function nav(store,nav,complete) {
    if(!store.getState()[nav].transitioning) complete();
    else {
        const unsub = store.subscribe(()=>{
            if(!store.getState()[nav].transitioning) {
                complete();
                unsub();
            }
        });
    }
}



let hide_all_logs = false,
    show_log = true && !hide_all_logs,
    show_warn = true && !hide_all_logs,
    show_error = true && !hide_all_logs;

let log = (m) => {
    if (!show_log) {return;}
    let t = m.type.toString(),
        n = t.indexOf('Symbol') < 0 ?
            t :
            t.substr(7+6,t.length-6-7-1);
    console.log(n, '[', m.payload.meta.endpoint, ']', m.payload);
}

let warn = (m) => {
    if (!show_warn) {return;}
    let t = m.type.toString(),
        n = t.indexOf('Symbol') < 0 ?
            t :
            t.substr(7+6,t.length-6-7-1);
    console.warn(n, '[', m.payload.meta.endpoint, ']', m.payload);
}

let error = (m) => {
    if (!show_error) {return;}
    let t = m.type.toString(),
        n = t.indexOf('Symbol') < 0 ?
            t :
            t.substr(7+6,t.length-6-7-1);
    console.error(n, '[', m.payload.meta.endpoint, ']', m.payload);
}


function sleep(milliseconds) {
    var start = new Date().getTime();
    for (var i = 0; i < 1e7; i++) {
        if ((new Date().getTime() - start) > milliseconds){
            break;
        }
    }
}
