
(* The type of tokens. *)

type token = 
  | WITH
  | WHILE
  | WHEN
  | VIRTUAL
  | VAL
  | UNDERSCORE
  | UIDENT of (string)
  | TYPE
  | TRY
  | TRUE
  | TO
  | TILDE
  | THEN
  | SWITCH
  | STRUCT
  | STRING of (string * string option * string option)
  | STAR
  | SLASHGREATER
  | SIG
  | SHARPOP of (string)
  | SHARP
  | SEMISEMI
  | SEMI
  | RPAREN
  | REC
  | RBRACKET
  | RBRACE
  | QUOTE
  | QUESTION
  | PUB
  | PRI
  | PREFIXOP of (string)
  | POSTFIXOP of (string)
  | PLUSEQ
  | PLUSDOT
  | PLUS
  | PERCENT
  | OR
  | OPEN
  | OF
  | OBJECT
  | NONREC
  | NEW
  | NATIVEINT of (nativeint)
  | MUTABLE
  | MODULE
  | MINUSGREATER
  | MINUSDOT
  | MINUS
  | LPAREN
  | LIDENT of (string)
  | LET
  | LESSSLASHIDENTGREATER of (string)
  | LESSSLASHGREATER
  | LESSIDENT of (string)
  | LESSGREATER
  | LESSDOTDOTGREATER
  | LESS
  | LBRACKETPERCENTPERCENT
  | LBRACKETPERCENT
  | LBRACKETLESS
  | LBRACKETGREATER
  | LBRACKETBAR
  | LBRACKETAT
  | LBRACKET
  | LBRACELESS
  | LBRACE
  | LAZY
  | LABEL_WITH_EQUAL of (string)
  | INT of (string * char option)
  | INITIALIZER
  | INHERIT
  | INFIXOP4 of (string)
  | INFIXOP3 of (string)
  | INFIXOP2 of (string)
  | INFIXOP1 of (string)
  | INFIXOP0 of (string)
  | INCLUDE
  | IN
  | IF
  | GREATERRBRACE
  | GREATER
  | FUNCTOR
  | FUNCTION
  | FUN
  | FOR
  | FLOAT of (string * char option)
  | FALSE
  | EXTERNAL
  | EXCEPTION
  | ES6_FUN
  | EQUALGREATER
  | EQUAL
  | EOL
  | EOF
  | END
  | ELSE
  | DOWNTO
  | DOTDOTDOT
  | DOTDOT
  | DOT
  | DONE
  | DOCSTRING of (string)
  | DO
  | CONSTRAINT
  | COMMENT of (string * Location.t)
  | COMMA
  | COLONGREATER
  | COLONEQUAL
  | COLONCOLON
  | COLON
  | CLASS
  | CHAR of (char)
  | BEGIN
  | BARRBRACKET
  | BARBAR
  | BAR
  | BANG
  | BACKQUOTE
  | ASSERT
  | AS
  | AND
  | AMPERSAND
  | AMPERAMPER

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val use_file: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.toplevel_phrase list)

val toplevel_phrase: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.toplevel_phrase)

val parse_pattern: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.pattern)

val parse_expression: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.expression)

val parse_core_type: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.core_type)

val interface: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.signature)

val implementation: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Ast_404.Parsetree.structure)

module MenhirInterpreter : sig
  
  (* The incremental API. *)
  
  include MenhirLib.IncrementalEngine.INCREMENTAL_ENGINE
    with type token = token
  
end

(* The entry point(s) to the incremental API. *)

module Incremental : sig
  
  val use_file: Lexing.position -> (Ast_404.Parsetree.toplevel_phrase list) MenhirInterpreter.checkpoint
  
  val toplevel_phrase: Lexing.position -> (Ast_404.Parsetree.toplevel_phrase) MenhirInterpreter.checkpoint
  
  val parse_pattern: Lexing.position -> (Ast_404.Parsetree.pattern) MenhirInterpreter.checkpoint
  
  val parse_expression: Lexing.position -> (Ast_404.Parsetree.expression) MenhirInterpreter.checkpoint
  
  val parse_core_type: Lexing.position -> (Ast_404.Parsetree.core_type) MenhirInterpreter.checkpoint
  
  val interface: Lexing.position -> (Ast_404.Parsetree.signature) MenhirInterpreter.checkpoint
  
  val implementation: Lexing.position -> (Ast_404.Parsetree.structure) MenhirInterpreter.checkpoint
  
end
