/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.postprocessors.IterativeBoxBlurPostProcessor;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.image.ImageLoadEvent;
import com.facebook.react.views.image.ImageResizeMethod;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.MultiSourceHelper;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactImageView
extends GenericDraweeView {
    public static final int REMOTE_IMAGE_FADE_DURATION_MS = 300;
    private static float[] sComputedCornerRadii = new float[4];
    private static final Matrix sMatrix = new Matrix();
    private static final Matrix sInverse = new Matrix();
    private ImageResizeMethod mResizeMethod = ImageResizeMethod.AUTO;
    private final List<ImageSource> mSources;
    @Nullable
    private ImageSource mImageSource;
    @Nullable
    private ImageSource mCachedImageSource;
    @Nullable
    private Drawable mLoadingImageDrawable;
    private int mBorderColor;
    private int mOverlayColor;
    private float mBorderWidth;
    private float mBorderRadius = Float.NaN;
    @Nullable
    private float[] mBorderCornerRadii;
    private ScalingUtils.ScaleType mScaleType = ImageResizeMode.defaultValue();
    private boolean mIsDirty;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    private final RoundedCornerPostprocessor mRoundedCornerPostprocessor;
    @Nullable
    private IterativeBoxBlurPostProcessor mIterativeBoxBlurPostProcessor;
    @Nullable
    private ControllerListener mControllerListener;
    @Nullable
    private ControllerListener mControllerForTesting;
    @Nullable
    private final Object mCallerContext;
    private int mFadeDurationMs = -1;
    private boolean mProgressiveRenderingEnabled;
    private ReadableMap mHeaders;

    private static GenericDraweeHierarchy buildHierarchy(Context context) {
        return new GenericDraweeHierarchyBuilder(context.getResources()).setRoundingParams(RoundingParams.fromCornersRadius((float)0.0f)).build();
    }

    public ReactImageView(Context context, AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        super(context, ReactImageView.buildHierarchy(context));
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mRoundedCornerPostprocessor = new RoundedCornerPostprocessor();
        this.mCallerContext = callerContext;
        this.mSources = new LinkedList<ImageSource>();
    }

    public void setShouldNotifyLoadEvents(boolean shouldNotify) {
        if (!shouldNotify) {
            this.mControllerListener = null;
        } else {
            final EventDispatcher mEventDispatcher = ((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mControllerListener = new BaseControllerListener<ImageInfo>(){

                public void onSubmit(String id2, Object callerContext) {
                    mEventDispatcher.dispatchEvent(new ImageLoadEvent(ReactImageView.this.getId(), 4));
                }

                public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
                    if (imageInfo != null) {
                        mEventDispatcher.dispatchEvent(new ImageLoadEvent(ReactImageView.this.getId(), 2, ReactImageView.this.mImageSource.getSource(), imageInfo.getWidth(), imageInfo.getHeight()));
                        mEventDispatcher.dispatchEvent(new ImageLoadEvent(ReactImageView.this.getId(), 3));
                    }
                }

                public void onFailure(String id2, Throwable throwable) {
                    mEventDispatcher.dispatchEvent(new ImageLoadEvent(ReactImageView.this.getId(), 1));
                    mEventDispatcher.dispatchEvent(new ImageLoadEvent(ReactImageView.this.getId(), 3));
                }
            };
        }
        this.mIsDirty = true;
    }

    public void setBlurRadius(float blurRadius) {
        this.mIterativeBoxBlurPostProcessor = blurRadius == 0.0f ? null : new IterativeBoxBlurPostProcessor((int)PixelUtil.toPixelFromDIP(blurRadius));
        this.mIsDirty = true;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.mIsDirty = true;
    }

    public void setOverlayColor(int overlayColor) {
        this.mOverlayColor = overlayColor;
        this.mIsDirty = true;
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = PixelUtil.toPixelFromDIP(borderWidth);
        this.mIsDirty = true;
    }

    public void setBorderRadius(float borderRadius) {
        if (!FloatUtil.floatsEqual(this.mBorderRadius, borderRadius)) {
            this.mBorderRadius = borderRadius;
            this.mIsDirty = true;
        }
    }

    public void setBorderRadius(float borderRadius, int position) {
        if (this.mBorderCornerRadii == null) {
            this.mBorderCornerRadii = new float[4];
            Arrays.fill(this.mBorderCornerRadii, Float.NaN);
        }
        if (!FloatUtil.floatsEqual(this.mBorderCornerRadii[position], borderRadius)) {
            this.mBorderCornerRadii[position] = borderRadius;
            this.mIsDirty = true;
        }
    }

    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.mIsDirty = true;
    }

    public void setResizeMethod(ImageResizeMethod resizeMethod) {
        this.mResizeMethod = resizeMethod;
        this.mIsDirty = true;
    }

    public void setSource(@Nullable ReadableArray sources) {
        this.mSources.clear();
        if (sources != null && sources.size() != 0) {
            if (sources.size() == 1) {
                ReadableMap source = sources.getMap(0);
                String uri = source.getString("uri");
                ImageSource imageSource = new ImageSource(this.getContext(), uri);
                this.mSources.add(imageSource);
                if (Uri.EMPTY.equals((Object)imageSource.getUri())) {
                    this.warnImageSource(uri);
                }
            } else {
                for (int idx = 0; idx < sources.size(); ++idx) {
                    ReadableMap source = sources.getMap(idx);
                    String uri = source.getString("uri");
                    ImageSource imageSource = new ImageSource(this.getContext(), uri, source.getDouble("width"), source.getDouble("height"));
                    this.mSources.add(imageSource);
                    if (!Uri.EMPTY.equals((Object)imageSource.getUri())) continue;
                    this.warnImageSource(uri);
                }
            }
        }
        this.mIsDirty = true;
    }

    public void setLoadingIndicatorSource(@Nullable String name) {
        Drawable drawable = ResourceDrawableIdHelper.getInstance().getResourceDrawable(this.getContext(), name);
        this.mLoadingImageDrawable = drawable != null ? new AutoRotateDrawable(drawable, 1000) : null;
        this.mIsDirty = true;
    }

    public void setProgressiveRenderingEnabled(boolean enabled) {
        this.mProgressiveRenderingEnabled = enabled;
    }

    public void setFadeDuration(int durationMs) {
        this.mFadeDurationMs = durationMs;
    }

    private void cornerRadii(float[] computedCorners) {
        float defaultBorderRadius = !YogaConstants.isUndefined(this.mBorderRadius) ? this.mBorderRadius : 0.0f;
        computedCorners[0] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[0]) ? this.mBorderCornerRadii[0] : defaultBorderRadius;
        computedCorners[1] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[1]) ? this.mBorderCornerRadii[1] : defaultBorderRadius;
        computedCorners[2] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[2]) ? this.mBorderCornerRadii[2] : defaultBorderRadius;
        computedCorners[3] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[3]) ? this.mBorderCornerRadii[3] : defaultBorderRadius;
    }

    public void setHeaders(ReadableMap headers) {
        this.mHeaders = headers;
    }

    public void maybeUpdateView() {
        if (!this.mIsDirty) {
            return;
        }
        if (this.hasMultipleSources() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        this.setSourceImage();
        if (this.mImageSource == null) {
            return;
        }
        boolean doResize = this.shouldResize(this.mImageSource);
        if (doResize && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        GenericDraweeHierarchy hierarchy = (GenericDraweeHierarchy)this.getHierarchy();
        hierarchy.setActualImageScaleType(this.mScaleType);
        if (this.mLoadingImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.mLoadingImageDrawable, ScalingUtils.ScaleType.CENTER);
        }
        boolean usePostprocessorScaling = this.mScaleType != ScalingUtils.ScaleType.CENTER_CROP && this.mScaleType != ScalingUtils.ScaleType.FOCUS_CROP;
        RoundingParams roundingParams = hierarchy.getRoundingParams();
        if (usePostprocessorScaling) {
            roundingParams.setCornersRadius(0.0f);
        } else {
            this.cornerRadii(sComputedCornerRadii);
            roundingParams.setCornersRadii(sComputedCornerRadii[0], sComputedCornerRadii[1], sComputedCornerRadii[2], sComputedCornerRadii[3]);
        }
        roundingParams.setBorder(this.mBorderColor, this.mBorderWidth);
        if (this.mOverlayColor != 0) {
            roundingParams.setOverlayColor(this.mOverlayColor);
        } else {
            roundingParams.setRoundingMethod(RoundingParams.RoundingMethod.BITMAP_ONLY);
        }
        hierarchy.setRoundingParams(roundingParams);
        hierarchy.setFadeDuration(this.mFadeDurationMs >= 0 ? this.mFadeDurationMs : (this.mImageSource.isResource() ? 0 : 300));
        RoundedCornerPostprocessor postprocessor = null;
        if (usePostprocessorScaling) {
            postprocessor = this.mRoundedCornerPostprocessor;
        } else if (this.mIterativeBoxBlurPostProcessor != null) {
            postprocessor = this.mIterativeBoxBlurPostProcessor;
        }
        ResizeOptions resizeOptions = doResize ? new ResizeOptions(this.getWidth(), this.getHeight()) : null;
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)this.mImageSource.getUri()).setPostprocessor((Postprocessor)postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled);
        ReactNetworkImageRequest imageRequest = ReactNetworkImageRequest.fromBuilderWithHeaders(imageRequestBuilder, this.mHeaders);
        this.mDraweeControllerBuilder.reset();
        this.mDraweeControllerBuilder.setAutoPlayAnimations(true).setCallerContext(this.mCallerContext).setOldController(this.getController()).setImageRequest((Object)imageRequest);
        if (this.mCachedImageSource != null) {
            ImageRequest cachedImageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)this.mCachedImageSource.getUri()).setPostprocessor((Postprocessor)postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled).build();
            this.mDraweeControllerBuilder.setLowResImageRequest((Object)cachedImageRequest);
        }
        if (this.mControllerListener != null && this.mControllerForTesting != null) {
            ForwardingControllerListener combinedListener = new ForwardingControllerListener();
            combinedListener.addListener(this.mControllerListener);
            combinedListener.addListener(this.mControllerForTesting);
            this.mDraweeControllerBuilder.setControllerListener((ControllerListener)combinedListener);
        } else if (this.mControllerForTesting != null) {
            this.mDraweeControllerBuilder.setControllerListener(this.mControllerForTesting);
        } else if (this.mControllerListener != null) {
            this.mDraweeControllerBuilder.setControllerListener(this.mControllerListener);
        }
        this.setController((DraweeController)this.mDraweeControllerBuilder.build());
        this.mIsDirty = false;
        this.mDraweeControllerBuilder.reset();
    }

    public void setControllerListener(ControllerListener controllerListener) {
        this.mControllerForTesting = controllerListener;
        this.mIsDirty = true;
        this.maybeUpdateView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.mIsDirty = this.mIsDirty || this.hasMultipleSources();
            this.maybeUpdateView();
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    private boolean hasMultipleSources() {
        return this.mSources.size() > 1;
    }

    private void setSourceImage() {
        this.mImageSource = null;
        if (this.mSources.isEmpty()) {
            return;
        }
        if (this.hasMultipleSources()) {
            MultiSourceHelper.MultiSourceResult multiSource = MultiSourceHelper.getBestSourceForSize(this.getWidth(), this.getHeight(), this.mSources);
            this.mImageSource = multiSource.getBestResult();
            this.mCachedImageSource = multiSource.getBestResultInCache();
            return;
        }
        this.mImageSource = this.mSources.get(0);
    }

    private boolean shouldResize(ImageSource imageSource) {
        if (this.mResizeMethod == ImageResizeMethod.AUTO) {
            return UriUtil.isLocalContentUri((Uri)imageSource.getUri()) || UriUtil.isLocalFileUri((Uri)imageSource.getUri());
        }
        return this.mResizeMethod == ImageResizeMethod.RESIZE;
    }

    private void warnImageSource(String uri) {
    }

    private class RoundedCornerPostprocessor
    extends BasePostprocessor {
        private RoundedCornerPostprocessor() {
        }

        void getRadii(Bitmap source, float[] computedCornerRadii, float[] mappedRadii) {
            ReactImageView.this.mScaleType.getTransform(sMatrix, new Rect(0, 0, source.getWidth(), source.getHeight()), source.getWidth(), source.getHeight(), 0.0f, 0.0f);
            sMatrix.invert(sInverse);
            mappedRadii[0] = sInverse.mapRadius(computedCornerRadii[0]);
            mappedRadii[1] = mappedRadii[0];
            mappedRadii[2] = sInverse.mapRadius(computedCornerRadii[1]);
            mappedRadii[3] = mappedRadii[2];
            mappedRadii[4] = sInverse.mapRadius(computedCornerRadii[2]);
            mappedRadii[5] = mappedRadii[4];
            mappedRadii[6] = sInverse.mapRadius(computedCornerRadii[3]);
            mappedRadii[7] = mappedRadii[6];
        }

        public void process(Bitmap output, Bitmap source) {
            ReactImageView.this.cornerRadii(sComputedCornerRadii);
            output.setHasAlpha(true);
            if (FloatUtil.floatsEqual(sComputedCornerRadii[0], 0.0f) && FloatUtil.floatsEqual(sComputedCornerRadii[1], 0.0f) && FloatUtil.floatsEqual(sComputedCornerRadii[2], 0.0f) && FloatUtil.floatsEqual(sComputedCornerRadii[3], 0.0f)) {
                super.process(output, source);
                return;
            }
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            Canvas canvas = new Canvas(output);
            float[] radii = new float[8];
            this.getRadii(source, sComputedCornerRadii, radii);
            Path pathForBorderRadius = new Path();
            pathForBorderRadius.addRoundRect(new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight()), radii, Path.Direction.CW);
            canvas.drawPath(pathForBorderRadius, paint);
        }
    }
}

