/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.statusbar;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.WindowInsets;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="StatusBarManager")
public class StatusBarModule
extends ReactContextBaseJavaModule {
    private static final String HEIGHT_KEY = "HEIGHT";

    public StatusBarModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "StatusBarManager";
    }

    @Override
    @Nullable
    public Map<String, Object> getConstants() {
        ReactApplicationContext context = this.getReactApplicationContext();
        int heightResId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        float height = heightResId > 0 ? PixelUtil.toDIPFromPixel(context.getResources().getDimensionPixelSize(heightResId)) : 0.0f;
        return MapBuilder.of(HEIGHT_KEY, Float.valueOf(height));
    }

    @ReactMethod
    public void setColor(final int color, final boolean animated) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            UiThreadUtil.runOnUiThread(new GuardedRunnable(this.getReactApplicationContext()){

                @Override
                @TargetApi(value=21)
                public void runGuarded() {
                    if (animated) {
                        int curColor = activity.getWindow().getStatusBarColor();
                        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{curColor, color});
                        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animator) {
                                activity.getWindow().setStatusBarColor(((Integer)animator.getAnimatedValue()).intValue());
                            }
                        });
                        colorAnimation.setDuration(300L).setStartDelay(0L);
                        colorAnimation.start();
                    } else {
                        activity.getWindow().setStatusBarColor(color);
                    }
                }
            });
        }
    }

    @ReactMethod
    public void setTranslucent(final boolean translucent) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            UiThreadUtil.runOnUiThread(new GuardedRunnable(this.getReactApplicationContext()){

                @Override
                @TargetApi(value=21)
                public void runGuarded() {
                    View decorView = activity.getWindow().getDecorView();
                    if (translucent) {
                        decorView.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                            public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                                WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
                                return defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
                            }
                        });
                    } else {
                        decorView.setOnApplyWindowInsetsListener(null);
                    }
                    ViewCompat.requestApplyInsets((View)decorView);
                }
            });
        }
    }

    @ReactMethod
    public void setHidden(final boolean hidden) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (hidden) {
                    activity.getWindow().addFlags(1024);
                    activity.getWindow().clearFlags(2048);
                } else {
                    activity.getWindow().addFlags(2048);
                    activity.getWindow().clearFlags(1024);
                }
            }
        });
    }

    @ReactMethod
    public void setStyle(final String style) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                @TargetApi(value=23)
                public void run() {
                    View decorView = activity.getWindow().getDecorView();
                    decorView.setSystemUiVisibility(style.equals("dark-content") ? 8192 : 0);
                }
            });
        }
    }
}

