/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;

public class OrientedDrawable
extends ForwardingDrawable {
    @VisibleForTesting
    final Matrix mRotationMatrix;
    private int mRotationAngle;
    private final Matrix mTempMatrix = new Matrix();
    private final RectF mTempRectF = new RectF();

    public OrientedDrawable(Drawable drawable, int rotationAngle) {
        super(drawable);
        Preconditions.checkArgument((rotationAngle % 90 == 0 ? 1 : 0) != 0);
        this.mRotationMatrix = new Matrix();
        this.mRotationAngle = rotationAngle;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mRotationAngle <= 0) {
            super.draw(canvas);
            return;
        }
        int saveCount = canvas.save();
        canvas.concat(this.mRotationMatrix);
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mRotationAngle % 180 == 0 ? super.getIntrinsicWidth() : super.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mRotationAngle % 180 == 0 ? super.getIntrinsicHeight() : super.getIntrinsicWidth();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Drawable underlyingDrawable = this.getCurrent();
        if (this.mRotationAngle > 0) {
            this.mRotationMatrix.setRotate((float)this.mRotationAngle, (float)bounds.centerX(), (float)bounds.centerY());
            this.mTempMatrix.reset();
            this.mRotationMatrix.invert(this.mTempMatrix);
            this.mTempRectF.set(bounds);
            this.mTempMatrix.mapRect(this.mTempRectF);
            underlyingDrawable.setBounds((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
        } else {
            underlyingDrawable.setBounds(bounds);
        }
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
        if (!this.mRotationMatrix.isIdentity()) {
            transform.preConcat(this.mRotationMatrix);
        }
    }
}

