/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import com.facebook.soloader.MinElf;
import com.facebook.soloader.SoLoader;
import com.facebook.soloader.SoSource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class DirectorySoSource
extends SoSource {
    public static final int RESOLVE_DEPENDENCIES = 1;
    public static final int ON_LD_LIBRARY_PATH = 2;
    protected final File soDirectory;
    protected final int flags;

    public DirectorySoSource(File soDirectory, int flags) {
        this.soDirectory = soDirectory;
        this.flags = flags;
    }

    @Override
    public int loadLibrary(String soName, int loadFlags) throws IOException {
        return this.loadLibraryFrom(soName, loadFlags, this.soDirectory);
    }

    protected int loadLibraryFrom(String soName, int loadFlags, File libDir) throws IOException {
        File soFile = new File(libDir, soName);
        if (!soFile.exists()) {
            return 0;
        }
        if ((loadFlags & 1) != 0 && (this.flags & 2) != 0) {
            return 2;
        }
        if ((this.flags & 1) != 0) {
            String[] dependencies = DirectorySoSource.getDependencies(soFile);
            for (int i = 0; i < dependencies.length; ++i) {
                String dependency = dependencies[i];
                if (dependency.startsWith("/")) continue;
                SoLoader.loadLibraryBySoName(dependency, loadFlags | 1);
            }
        }
        System.load(soFile.getAbsolutePath());
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getDependencies(File soFile) throws IOException {
        String[] stringArray = MinElf.extract_DT_NEEDED(soFile);
        return stringArray;
    }

    @Override
    public File unpackLibrary(String soName) throws IOException {
        File soFile = new File(this.soDirectory, soName);
        if (soFile.exists()) {
            return soFile;
        }
        return null;
    }

    @Override
    public void addToLdLibraryPath(Collection<String> paths) {
        paths.add(this.soDirectory.getAbsolutePath());
    }
}

