/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.TextView;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.view.ReactViewBackgroundDrawable;
import javax.annotation.Nullable;

public class ReactTextView
extends TextView
implements ReactCompoundView {
    private static final ViewGroup.LayoutParams EMPTY_LAYOUT_PARAMS = new ViewGroup.LayoutParams(0, 0);
    private boolean mContainsImages;
    private int mDefaultGravityHorizontal;
    private int mDefaultGravityVertical;
    private boolean mTextIsSelectable;
    private float mLineHeight = Float.NaN;
    private int mTextAlign = 0;
    private int mNumberOfLines = Integer.MAX_VALUE;
    private TextUtils.TruncateAt mEllipsizeLocation = TextUtils.TruncateAt.END;
    private ReactViewBackgroundDrawable mReactBackgroundDrawable;

    public ReactTextView(Context context) {
        super(context);
        this.mDefaultGravityHorizontal = this.getGravity() & 0x800007;
        this.mDefaultGravityVertical = this.getGravity() & 0x70;
    }

    public void setText(ReactTextUpdate update) {
        this.mContainsImages = update.containsImages();
        if (this.getLayoutParams() == null) {
            this.setLayoutParams(EMPTY_LAYOUT_PARAMS);
        }
        this.setText((CharSequence)update.getText());
        this.setPadding((int)Math.floor(update.getPaddingLeft()), (int)Math.floor(update.getPaddingTop()), (int)Math.floor(update.getPaddingRight()), (int)Math.floor(update.getPaddingBottom()));
        int nextTextAlign = update.getTextAlign();
        if (this.mTextAlign != nextTextAlign) {
            this.mTextAlign = nextTextAlign;
        }
        this.setGravityHorizontal(this.mTextAlign);
        if (Build.VERSION.SDK_INT >= 23 && this.getBreakStrategy() != update.getTextBreakStrategy()) {
            this.setBreakStrategy(update.getTextBreakStrategy());
        }
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        int index;
        ReactTagSpan[] spans;
        Spanned text = (Spanned)this.getText();
        int target = this.getId();
        int x = (int)touchX;
        int y = (int)touchY;
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return target;
        }
        int line = layout2.getLineForVertical(y);
        int lineStartX = (int)layout2.getLineLeft(line);
        int lineEndX = (int)layout2.getLineRight(line);
        if (x >= lineStartX && x <= lineEndX && (spans = (ReactTagSpan[])text.getSpans(index = layout2.getOffsetForHorizontal(line, (float)x), index, ReactTagSpan.class)) != null) {
            int targetSpanTextLength = text.length();
            for (int i = 0; i < spans.length; ++i) {
                int spanStart = text.getSpanStart((Object)spans[i]);
                int spanEnd = text.getSpanEnd((Object)spans[i]);
                if (spanEnd <= index || spanEnd - spanStart > targetSpanTextLength) continue;
                target = spans[i].getReactTag();
                targetSpanTextLength = spanEnd - spanStart;
            }
        }
        return target;
    }

    public void setTextIsSelectable(boolean selectable) {
        this.mTextIsSelectable = selectable;
        super.setTextIsSelectable(selectable);
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mReactBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? Integer.MAX_VALUE : numberOfLines;
        this.setSingleLine(this.mNumberOfLines == 1);
        this.setMaxLines(this.mNumberOfLines);
    }

    public void setEllipsizeLocation(TextUtils.TruncateAt ellipsizeLocation) {
        this.mEllipsizeLocation = ellipsizeLocation;
    }

    public void updateView() {
        TextUtils.TruncateAt ellipsizeLocation = this.mNumberOfLines == Integer.MAX_VALUE ? null : this.mEllipsizeLocation;
        this.setEllipsize(ellipsizeLocation);
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.getOrCreateReactViewBackground().setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.getOrCreateReactViewBackground().setBorderStyle(style2);
    }

    private ReactViewBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mReactBackgroundDrawable == null) {
            this.mReactBackgroundDrawable = new ReactViewBackgroundDrawable();
            Drawable backgroundDrawable = this.getBackground();
            super.setBackground(null);
            if (backgroundDrawable == null) {
                super.setBackground((Drawable)this.mReactBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, backgroundDrawable});
                super.setBackground((Drawable)layerDrawable);
            }
        }
        return this.mReactBackgroundDrawable;
    }
}

