/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.listener;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ForwardingRequestListener
implements RequestListener {
    private static final String TAG = "ForwardingRequestListener";
    private final List<RequestListener> mRequestListeners;

    public ForwardingRequestListener(Set<RequestListener> requestListeners) {
        this.mRequestListeners = new ArrayList<RequestListener>(requestListeners.size());
        for (RequestListener requestListener : requestListeners) {
            if (requestListener == null) continue;
            this.mRequestListeners.add(requestListener);
        }
    }

    public ForwardingRequestListener(RequestListener ... requestListeners) {
        this.mRequestListeners = new ArrayList<RequestListener>(requestListeners.length);
        for (RequestListener requestListener : requestListeners) {
            if (requestListener == null) continue;
            this.mRequestListeners.add(requestListener);
        }
    }

    @Override
    public void onRequestStart(ImageRequest request, Object callerContext, String requestId, boolean isPrefetch) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestStart(request, callerContext, requestId, isPrefetch);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestStart", exception);
            }
        }
    }

    @Override
    public void onProducerStart(String requestId, String producerName) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerStart(requestId, producerName);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerStart", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithSuccess(String requestId, String producerName, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithSuccess(requestId, producerName, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithSuccess", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithFailure(String requestId, String producerName, Throwable t, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithFailure(requestId, producerName, t, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithFailure", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithCancellation(String requestId, String producerName, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithCancellation(requestId, producerName, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithCancellation", exception);
            }
        }
    }

    @Override
    public void onProducerEvent(String requestId, String producerName, String producerEventName) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerEvent(requestId, producerName, producerEventName);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onIntermediateChunkStart", exception);
            }
        }
    }

    @Override
    public void onUltimateProducerReached(String requestId, String producerName, boolean successful) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onUltimateProducerReached(requestId, producerName, successful);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithSuccess", exception);
            }
        }
    }

    @Override
    public void onRequestSuccess(ImageRequest request, String requestId, boolean isPrefetch) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestSuccess(request, requestId, isPrefetch);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestSuccess", exception);
            }
        }
    }

    @Override
    public void onRequestFailure(ImageRequest request, String requestId, Throwable throwable, boolean isPrefetch) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestFailure(request, requestId, throwable, isPrefetch);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestFailure", exception);
            }
        }
    }

    @Override
    public void onRequestCancellation(String requestId) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestCancellation(requestId);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestCancellation", exception);
            }
        }
    }

    @Override
    public boolean requiresExtraMap(String id) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            if (!this.mRequestListeners.get(i).requiresExtraMap(id)) continue;
            return true;
        }
        return false;
    }

    private void onException(String message, Throwable t) {
        FLog.e((String)TAG, (String)message, (Throwable)t);
    }
}

