/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.os.Build;
import android.os.Parcel;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class SysUtil {
    private static final byte APK_SIGNATURE_VERSION = 1;

    public static int findAbiScore(String[] supportedAbis, String abi) {
        for (int i = 0; i < supportedAbis.length; ++i) {
            if (supportedAbis[i] == null || !abi.equals(supportedAbis[i])) continue;
            return i;
        }
        return -1;
    }

    public static void deleteOrThrow(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("could not delete file " + file);
        }
    }

    public static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return LollipopSysdeps.getSupportedAbis();
    }

    public static void fallocateIfSupported(FileDescriptor fd, long length) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            LollipopSysdeps.fallocateIfSupported(fd, length);
        }
    }

    public static void dumbDeleteRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            if (fileList == null) {
                return;
            }
            for (File entry : fileList) {
                SysUtil.dumbDeleteRecursive(entry);
            }
        }
        if (!file.delete() && file.exists()) {
            throw new IOException("could not delete: " + file);
        }
    }

    static void mkdirOrThrow(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("cannot mkdir: " + dir);
        }
    }

    static int copyBytes(RandomAccessFile os, InputStream is, int byteLimit, byte[] buffer) throws IOException {
        int bytesCopied;
        int nrRead;
        for (bytesCopied = 0; bytesCopied < byteLimit && (nrRead = is.read(buffer, 0, Math.min(buffer.length, byteLimit - bytesCopied))) != -1; bytesCopied += nrRead) {
            os.write(buffer, 0, nrRead);
        }
        return bytesCopied;
    }

    static void fsyncRecursive(File fileName) throws IOException {
        if (fileName.isDirectory()) {
            File[] files = fileName.listFiles();
            if (files == null) {
                throw new IOException("cannot list directory " + fileName);
            }
            for (int i = 0; i < files.length; ++i) {
                SysUtil.fsyncRecursive(files[i]);
            }
        } else if (!fileName.getPath().endsWith("_lock")) {
            try (RandomAccessFile file = new RandomAccessFile(fileName, "r");){
                file.getFD().sync();
            }
        }
    }

    public static byte[] makeApkDepBlock(File apkFile) {
        Parcel parcel = Parcel.obtain();
        parcel.writeByte((byte)1);
        parcel.writeString(apkFile.getPath());
        parcel.writeLong(apkFile.lastModified());
        byte[] depsBlock = parcel.marshall();
        parcel.recycle();
        return depsBlock;
    }

    private static final class LollipopSysdeps {
        private LollipopSysdeps() {
        }

        public static String[] getSupportedAbis() {
            return Build.SUPPORTED_32_BIT_ABIS;
        }

        public static void fallocateIfSupported(FileDescriptor fd, long length) throws IOException {
            block2: {
                try {
                    Os.posix_fallocate((FileDescriptor)fd, (long)0L, (long)length);
                }
                catch (ErrnoException ex) {
                    if (ex.errno == OsConstants.EOPNOTSUPP || ex.errno == OsConstants.ENOSYS || ex.errno == OsConstants.EINVAL) break block2;
                    throw new IOException(ex.toString(), ex);
                }
            }
        }
    }
}

