/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import java.util.UUID;

public class ObjectIdGenerators {

    public static final class UUIDGenerator
    extends Base<UUID> {
        private static final long serialVersionUID = 1L;

        public UUIDGenerator() {
            this(Object.class);
        }

        private UUIDGenerator(Class<?> clazz2) {
            super(Object.class);
        }

        @Override
        public ObjectIdGenerator<UUID> forScope(Class<?> clazz2) {
            return this;
        }

        @Override
        public ObjectIdGenerator<UUID> newForSerialization(Object object) {
            return this;
        }

        @Override
        public UUID generateId(Object object) {
            return UUID.randomUUID();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            return new ObjectIdGenerator.IdKey(this.getClass(), null, object);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass();
        }
    }

    public static final class IntSequenceGenerator
    extends Base<Integer> {
        private static final long serialVersionUID = 1L;
        protected transient int _nextValue;

        public IntSequenceGenerator() {
            this(Object.class, -1);
        }

        public IntSequenceGenerator(Class<?> clazz2, int n) {
            super(clazz2);
            this._nextValue = n;
        }

        protected int initialValue() {
            return 1;
        }

        @Override
        public ObjectIdGenerator<Integer> forScope(Class<?> clazz2) {
            return this._scope == clazz2 ? this : new IntSequenceGenerator(clazz2, this._nextValue);
        }

        @Override
        public ObjectIdGenerator<Integer> newForSerialization(Object object) {
            return new IntSequenceGenerator(this._scope, this.initialValue());
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            return new ObjectIdGenerator.IdKey(this.getClass(), this._scope, object);
        }

        @Override
        public Integer generateId(Object object) {
            int n = this._nextValue++;
            return n;
        }
    }

    public static abstract class PropertyGenerator
    extends Base<Object> {
        private static final long serialVersionUID = 1L;

        protected PropertyGenerator(Class<?> clazz2) {
            super(clazz2);
        }
    }

    public static abstract class None
    extends ObjectIdGenerator<Object> {
    }

    private static abstract class Base<T>
    extends ObjectIdGenerator<T> {
        protected final Class<?> _scope;

        protected Base(Class<?> clazz2) {
            this._scope = clazz2;
        }

        @Override
        public final Class<?> getScope() {
            return this._scope;
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass() && objectIdGenerator.getScope() == this._scope;
        }

        @Override
        public abstract T generateId(Object var1);
    }
}

