/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected final Writer _writer;
    protected char[] _outputBuffer;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;

    public WriterBasedJsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, Writer writer) {
        super(iOContext, n, objectCodec);
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public void writeFieldName(String string2) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(string2);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string2, n == 1);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(serializableString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n == 1);
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    protected void _writeFieldName(String string2, boolean bl) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string2, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string2);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void _writeFieldName(SerializableString serializableString, boolean bl) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        char[] cArray = serializableString.asQuotedChars();
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        int n = cArray.length;
        if (this._outputTail + n + 1 >= this._outputEnd) {
            this.writeRaw(cArray, 0, n);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
            this._outputBuffer[this._outputTail++] = 34;
        }
    }

    protected void _writePPFieldName(String string2, boolean bl) throws IOException, JsonGenerationException {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this._writeString(string2);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this._writeString(string2);
        }
    }

    protected void _writePPFieldName(SerializableString serializableString, boolean bl) throws IOException, JsonGenerationException {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        char[] cArray = serializableString.asQuotedChars();
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this.writeRaw(cArray, 0, cArray.length);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this.writeRaw(cArray, 0, cArray.length);
        }
    }

    @Override
    public void writeString(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (string2 == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        char[] cArray = serializableString.asQuotedChars();
        int n = cArray.length;
        if (n < 32) {
            int n2 = this._outputEnd - this._outputTail;
            if (n > n2) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            this._writer.write(cArray, 0, n);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string2) throws IOException, JsonGenerationException {
        int n = string2.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string2.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
        } else {
            this.writeRawLong(string2);
        }
    }

    @Override
    public void writeRaw(String string2, int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string2.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string2.substring(n, n + n2));
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n, n2);
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String string2) throws IOException, JsonGenerationException {
        int n;
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string2.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n = string2.length() - n3; n > this._outputEnd; n -= n2) {
            n2 = this._outputEnd;
            string2.getChars(n4, n4 + n2, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        string2.getChars(n4, n4 + n, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n;
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) throws IOException, JsonGenerationException {
        int n2;
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n < 0) {
                n2 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                int n3 = this._writeBinary(base64Variant, inputStream, byArray, n);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n + ")");
                }
                n2 = n;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        return n2;
    }

    @Override
    public void writeNumber(short s2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s2);
            return;
        }
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedShort(short s2) throws IOException {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedInt(int n) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedLong(long l) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d) || Double.isInfinite(d)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f2) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f2) || Float.isInfinite(f2)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
        } else if (this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            this.writeRaw(bigDecimal.toPlainString());
        } else {
            this.writeRaw(bigDecimal.toString());
        }
    }

    @Override
    public void writeNumber(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string2);
        } else {
            this.writeRaw(string2);
        }
    }

    private void _writeQuotedRaw(Object object) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n] = 116;
            cArray[++n] = 114;
            cArray[++n] = 117;
            cArray[++n] = 101;
        } else {
            cArray[n] = 102;
            cArray[++n] = 97;
            cArray[++n] = 108;
            cArray[++n] = 115;
            cArray[++n] = 101;
        }
        this._outputTail = n + 1;
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    @Override
    protected void _verifyValueWrite(String string2) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string2 + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 44;
                    break;
                }
                case 2: {
                    n2 = 58;
                    break;
                }
                case 3: {
                    if (this._rootValueSeparator != null) {
                        this.writeRaw(this._rootValueSeparator.getValue());
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail] = n2;
            ++this._outputTail;
            return;
        }
        this._verifyPrettyValueWrite(string2, n);
    }

    protected void _verifyPrettyValueWrite(String string2, int n) throws IOException, JsonGenerationException {
        switch (n) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string2) throws IOException, JsonGenerationException {
        int n = string2.length();
        if (n > this._outputEnd) {
            this._writeLongString(string2);
            return;
        }
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
        }
        string2.getChars(0, n, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n);
        } else if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n, this._maximumNonEscapedChar);
        } else {
            this._writeString2(n);
        }
    }

    private void _writeString2(int n) throws IOException, JsonGenerationException {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        block0: while (this._outputTail < n2) {
            int n4;
            while ((n4 = this._outputBuffer[this._outputTail]) >= n3 || nArray[n4] == 0) {
                if (++this._outputTail < n2) continue;
                break block0;
            }
            n4 = this._outputTail - this._outputHead;
            if (n4 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n4);
            }
            char c = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeLongString(String string2) throws IOException, JsonGenerationException {
        int n;
        this._flushBuffer();
        int n2 = string2.length();
        int n3 = 0;
        do {
            int n4;
            n = n3 + (n4 = this._outputEnd) > n2 ? n2 - n3 : n4;
            string2.getChars(n3, n3 + n, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n);
        } while ((n3 += n) < n2);
    }

    private void _writeSegment(int n) throws IOException, JsonGenerationException {
        int n2;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        int n4 = n2 = 0;
        while (n2 < n) {
            char c;
            while (((c = this._outputBuffer[n2]) >= n3 || nArray[c] == 0) && ++n2 < n) {
            }
            int n5 = n2 - n4;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, n4, n5);
                if (n2 >= n) break;
            }
            n4 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n2, n, c, nArray[c]);
        }
    }

    private void _writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n, n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n, n2, this._maximumNonEscapedChar);
            return;
        }
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        while (n < n2) {
            int n4;
            int n5 = n;
            while (((n4 = cArray[n]) >= n3 || nArray[n4] == 0) && ++n < n2) {
            }
            n4 = n - n5;
            if (n4 < 32) {
                if (this._outputTail + n4 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n4 > 0) {
                    System.arraycopy(cArray, n5, this._outputBuffer, this._outputTail, n4);
                    this._outputTail += n4;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n5, n4);
            }
            if (n >= n2) break;
            char c = cArray[n++];
            this._appendCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeStringASCII(int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n2 + 1);
        int n5 = 0;
        while (this._outputTail < n3) {
            char c;
            block5: {
                do {
                    if ((c = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[c];
                        if (n5 == 0) continue;
                    } else {
                        if (c <= n2) continue;
                        n5 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n3);
                break;
            }
            int n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c, n5);
        }
    }

    private void _writeSegmentASCII(int n, int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n3 = Math.min(nArray.length, n2 + 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            char c;
            do {
                if ((c = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n2) continue;
                n5 = -1;
                break;
            } while (++n4 < n);
            int n7 = n4 - n6;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, n6, n7);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, c, n5);
        }
    }

    private void _writeStringASCII(char[] cArray, int n, int n2, int n3) throws IOException, JsonGenerationException {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        while (n < n2) {
            char c;
            int n6 = n;
            do {
                if ((c = cArray[n]) < n4) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n3) continue;
                n5 = -1;
                break;
            } while (++n < n2);
            int n7 = n - n6;
            if (n7 < 32) {
                if (this._outputTail + n7 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n7 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n7);
                    this._outputTail += n7;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n7);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape(c, n5);
        }
    }

    private void _writeStringCustom(int n) throws IOException, JsonGenerationException {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n2) {
            int n6;
            block7: {
                do {
                    if ((n6 = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[n6];
                        if (n5 == 0) continue;
                    } else if (n6 > n3) {
                        n5 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n6);
                        if (this._currentEscape == null) continue;
                        n5 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n2);
                break;
            }
            int n7 = this._outputTail - this._outputHead;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n7);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n6, n5);
        }
    }

    private void _writeSegmentCustom(int n) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n2 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, n2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            int n7;
            do {
                if ((n7 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[n7];
                    if (n5 == 0) continue;
                    break;
                }
                if (n7 > n2) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n4 < n);
            int n8 = n4 - n6;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n6, n8);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, (char)n7, n5);
        }
    }

    private void _writeStringCustom(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        while (n < n2) {
            int n6;
            int n7 = n;
            do {
                if ((n6 = cArray[n]) < n4) {
                    n5 = nArray[n6];
                    if (n5 == 0) continue;
                    break;
                }
                if (n6 > n3) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n6);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n < n2);
            int n8 = n - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape((char)n6, n5);
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = byArray[n++] << 8;
            n3 |= byArray[n++] & 0xFF;
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n7 = byArray[n++] << 16;
            if (n3 == 2) {
                n7 |= (byArray[n++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n7, n3, this._outputBuffer, this._outputTail);
        }
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n) throws IOException, JsonGenerationException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n > 2) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n > 0) {
            n4 = this._readMore(inputStream, byArray, n3, n4, n);
            n3 = 0;
            if (n4 > 0) {
                int n8;
                if (this._outputTail > n6) {
                    this._flushBuffer();
                }
                n2 = byArray[n3++] << 16;
                if (n3 < n4) {
                    n2 |= (byArray[n3] & 0xFF) << 8;
                    n8 = 2;
                } else {
                    n8 = 1;
                }
                this._outputTail = base64Variant.encodeBase64Partial(n2, n8, this._outputBuffer, this._outputTail);
                n -= n8;
            }
        }
        return n;
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) throws IOException, JsonGenerationException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) break;
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 8;
            n |= byArray[n2++] & 0xFF;
            n = n << 8 | byArray[n2++] & 0xFF;
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 < n3) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 16;
            int n8 = 1;
            if (n2 < n3) {
                n |= (byArray[n2] & 0xFF) << 8;
                n8 = 2;
            }
            n5 += n8;
            this._outputTail = base64Variant.encodeBase64Partial(n, n8, this._outputBuffer, this._outputTail);
        }
        return n5;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        while (n < n2) {
            byArray[n5++] = byArray[n++];
        }
        n = 0;
        n2 = n5;
        n3 = Math.min(n3, byArray.length);
        while ((n4 = n3 - n2) != 0) {
            int n6 = inputStream.read(byArray, n2, n4);
            if (n6 < 0) {
                return n2;
            }
            if ((n2 += n6) < 3) continue;
        }
        return n2;
    }

    private void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n] = 110;
        cArray[++n] = 117;
        cArray[++n] = 108;
        cArray[++n] = 108;
        this._outputTail = n + 1;
    }

    private void _prependOrWriteCharacterEscape(char c, int n) throws IOException, JsonGenerationException {
        String string2;
        if (n >= 0) {
            if (this._outputTail >= 2) {
                int n2;
                this._outputHead = n2 = this._outputTail - 2;
                this._outputBuffer[n2++] = 92;
                this._outputBuffer[n2] = (char)n;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n != -2) {
            if (this._outputTail >= 6) {
                int n3;
                char[] cArray = this._outputBuffer;
                this._outputHead = n3 = this._outputTail - 6;
                cArray[n3] = 92;
                cArray[++n3] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[++n3] = HEX_CHARS[n4 >> 4];
                    cArray[++n3] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[++n3] = 48;
                    cArray[++n3] = 48;
                }
                cArray[++n3] = HEX_CHARS[c >> 4];
                cArray[++n3] = HEX_CHARS[c & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c > '\u00ff') {
                int n5 = c >> 8 & 0xFF;
                int n6 = c & 0xFF;
                cArray[10] = HEX_CHARS[n5 >> 4];
                cArray[11] = HEX_CHARS[n5 & 0xF];
                cArray[12] = HEX_CHARS[n6 >> 4];
                cArray[13] = HEX_CHARS[n6 & 0xF];
                this._writer.write(cArray, 8, 6);
            } else {
                cArray[6] = HEX_CHARS[c >> 4];
                cArray[7] = HEX_CHARS[c & 0xF];
                this._writer.write(cArray, 2, 6);
            }
            return;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string2.length();
        if (this._outputTail >= n7) {
            int n8;
            this._outputHead = n8 = this._outputTail - n7;
            string2.getChars(0, n7, this._outputBuffer, n8);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string2);
    }

    private int _prependOrWriteCharacterEscape(char[] cArray, int n, int n2, char c, int n3) throws IOException, JsonGenerationException {
        String string2;
        if (n3 >= 0) {
            if (n > 1 && n < n2) {
                cArray[n -= 2] = 92;
                cArray[n + 1] = (char)n3;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (cArray2 == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n3;
                this._writer.write(cArray2, 0, 2);
            }
            return n;
        }
        if (n3 != -2) {
            if (n > 5 && n < n2) {
                n -= 6;
                cArray[n++] = 92;
                cArray[n++] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[n++] = HEX_CHARS[n4 >> 4];
                    cArray[n++] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                }
                cArray[n++] = HEX_CHARS[c >> 4];
                cArray[n] = HEX_CHARS[c & 0xF];
                n -= 5;
            } else {
                char[] cArray3 = this._entityBuffer;
                if (cArray3 == null) {
                    cArray3 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c > '\u00ff') {
                    int n5 = c >> 8 & 0xFF;
                    int n6 = c & 0xFF;
                    cArray3[10] = HEX_CHARS[n5 >> 4];
                    cArray3[11] = HEX_CHARS[n5 & 0xF];
                    cArray3[12] = HEX_CHARS[n6 >> 4];
                    cArray3[13] = HEX_CHARS[n6 & 0xF];
                    this._writer.write(cArray3, 8, 6);
                } else {
                    cArray3[6] = HEX_CHARS[c >> 4];
                    cArray3[7] = HEX_CHARS[c & 0xF];
                    this._writer.write(cArray3, 2, 6);
                }
            }
            return n;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string2.length();
        if (n >= n7 && n < n2) {
            string2.getChars(0, n7, cArray, n -= n7);
        } else {
            this._writer.write(string2);
        }
        return n;
    }

    private void _appendCharacterEscape(char c, int n) throws IOException, JsonGenerationException {
        String string2;
        if (n >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n;
            return;
        }
        if (n != -2) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            char[] cArray = this._outputBuffer;
            cArray[n2++] = 92;
            cArray[n2++] = 117;
            if (c > '\u00ff') {
                int n3 = c >> 8 & 0xFF;
                cArray[n2++] = HEX_CHARS[n3 >> 4];
                cArray[n2++] = HEX_CHARS[n3 & 0xF];
                c = (char)(c & 0xFF);
            } else {
                cArray[n2++] = 48;
                cArray[n2++] = 48;
            }
            cArray[n2++] = HEX_CHARS[c >> 4];
            cArray[n2++] = HEX_CHARS[c & 0xF];
            this._outputTail = n2;
            return;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n4 = string2.length();
        if (this._outputTail + n4 > this._outputEnd) {
            this._flushBuffer();
            if (n4 > this._outputEnd) {
                this._writer.write(string2);
                return;
            }
        }
        string2.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail += n4;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        cArray[0] = 92;
        cArray[2] = 92;
        cArray[3] = 117;
        cArray[4] = 48;
        cArray[5] = 48;
        cArray[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    protected void _flushBuffer() throws IOException {
        int n = this._outputTail - this._outputHead;
        if (n > 0) {
            int n2 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n);
        }
    }
}

