/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;

public class VersionUtil {
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    protected VersionUtil() {
        Version version2 = null;
        try {
            version2 = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information from " + this.getClass());
        }
        if (version2 == null) {
            version2 = Version.unknownVersion();
        }
        this._version = version2;
    }

    public Version version() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version versionFor(Class<?> clazz2) {
        Version version2 = VersionUtil.packageVersionFor(clazz2);
        if (version2 != null) {
            return version2;
        }
        InputStream inputStream = clazz2.getResourceAsStream("VERSION.txt");
        if (inputStream == null) {
            return Version.unknownVersion();
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            Version version3 = VersionUtil.doReadVersion(inputStreamReader);
            return version3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Version version4 = Version.unknownVersion();
            return version4;
        }
        finally {
            VersionUtil._close(inputStream);
        }
    }

    public static Version packageVersionFor(Class<?> clazz2) {
        try {
            String string2 = clazz2.getPackage().getName() + ".PackageVersion";
            Class<?> clazz3 = Class.forName(string2, true, clazz2.getClassLoader());
            try {
                return ((Versioned)clazz3.newInstance()).version();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to get Versioned out of " + clazz3);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version doReadVersion(Reader reader) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            string2 = bufferedReader.readLine();
            if (string2 != null && (string3 = bufferedReader.readLine()) != null) {
                string4 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            VersionUtil._close(bufferedReader);
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string4 != null) {
            string4 = string4.trim();
        }
        return VersionUtil.parseVersion(string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version mavenVersionFor(ClassLoader classLoader, String string2, String string3) {
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string2.replaceAll("\\.", "/") + "/" + string3 + "/pom.properties");
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string4 = properties.getProperty("version");
                String string5 = properties.getProperty("artifactId");
                String string6 = properties.getProperty("groupId");
                Version version2 = VersionUtil.parseVersion(string4, string6, string5);
                return version2;
            }
            catch (IOException iOException) {
            }
            finally {
                VersionUtil._close(inputStream);
            }
        }
        return Version.unknownVersion();
    }

    public static Version parseVersion(String string2, String string3, String string4) {
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            String[] stringArray = VERSION_SEPARATOR.split(string2);
            return new Version(VersionUtil.parseVersionPart(stringArray[0]), stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0, stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0, stringArray.length > 3 ? stringArray[3] : null, string3, string4);
        }
        return null;
    }

    protected static int parseVersionPart(String string2) {
        char c;
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2 && (c = string2.charAt(i)) <= '9' && c >= '0'; ++i) {
            n = n * 10 + (c - 48);
        }
        return n;
    }

    private static final void _close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

