/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;

public abstract class DatabindContext {
    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this.getConfig().isEnabled(mapperFeature);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.getConfig().canOverrideAccessModifiers();
    }

    public abstract Class<?> getActiveView();

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        return this.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType javaType2, Class<?> clazz2) {
        if (javaType2.getRawClass() == clazz2) {
            return javaType2;
        }
        return this.getConfig().constructSpecializedType(javaType2, clazz2);
    }

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        ObjectIdGenerator<?> objectIdGenerator;
        Class<? extends ObjectIdGenerator<?>> clazz2 = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator2 = objectIdGenerator = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, annotated, clazz2);
        if (objectIdGenerator == null) {
            objectIdGenerator = ClassUtil.createInstance(clazz2, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object object) throws JsonMappingException {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == Converter.None.class || clazz2 == NoClass.class) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz2)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz2.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(mapperConfig, annotated, clazz2);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz2, mapperConfig.canOverrideAccessModifiers());
        }
        return converter;
    }
}

