/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = -4251443320039569153L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;
    protected final RootNameLookup _rootNames;

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType2, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._parserFactory = objectMapper._jsonFactory;
        this._rootNames = objectMapper._rootNames;
        this._valueType = javaType2;
        this._valueToUpdate = object;
        if (object != null && javaType2.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(deserializationConfig, javaType2);
        this._dataFormatReaders = null;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType2, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._rootNames = objectReader._rootNames;
        this._valueType = javaType2;
        this._rootDeserializer = jsonDeserializer;
        this._valueToUpdate = object;
        if (object != null && javaType2.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._rootNames = objectReader._rootNames;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = objectReader._dataFormatReaders;
    }

    protected ObjectReader(ObjectReader objectReader, JsonFactory jsonFactory) {
        this._config = objectReader._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = jsonFactory;
        this._rootNames = objectReader._rootNames;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectReader with(DeserializationConfig deserializationConfig) {
        return this._with(deserializationConfig);
    }

    public ObjectReader with(DeserializationFeature deserializationFeature) {
        return this._with(this._config.with(deserializationFeature));
    }

    public ObjectReader with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withFeatures(deserializationFeatureArray));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature) {
        return this._with(this._config.without(deserializationFeature));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.without(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withoutFeatures(deserializationFeatureArray));
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return new ObjectReader(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader with(JsonNodeFactory jsonNodeFactory) {
        return this._with(this._config.with(jsonNodeFactory));
    }

    public ObjectReader with(JsonFactory jsonFactory) {
        if (jsonFactory == this._parserFactory) {
            return this;
        }
        ObjectReader objectReader = new ObjectReader(this, jsonFactory);
        if (jsonFactory.getCodec() == null) {
            jsonFactory.setCodec(objectReader);
        }
        return objectReader;
    }

    public ObjectReader withRootName(String string2) {
        return this._with(this._config.withRootName(string2));
    }

    public ObjectReader with(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return new ObjectReader(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, formatSchema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader withType(JavaType javaType2) {
        if (javaType2 != null && javaType2.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> jsonDeserializer = this._prefetchRootDeserializer(this._config, javaType2);
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            dataFormatReaders = dataFormatReaders.withType(javaType2);
        }
        return new ObjectReader(this, this._config, javaType2, jsonDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader withType(Class<?> clazz2) {
        return this.withType(this._config.constructType(clazz2));
    }

    public ObjectReader withType(Type type) {
        return this.withType(this._config.getTypeFactory().constructType(type));
    }

    public ObjectReader withType(TypeReference<?> typeReference) {
        return this.withType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        if (object == this._valueToUpdate) {
            return this;
        }
        if (object == null) {
            throw new IllegalArgumentException("cat not update null value");
        }
        JavaType javaType2 = this._valueType == null ? this._config.constructType(object.getClass()) : this._valueType;
        return new ObjectReader(this, this._config, javaType2, this._rootDeserializer, object, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader withView(Class<?> clazz2) {
        return this._with((DeserializationConfig)this._config.withView((Class)clazz2));
    }

    public ObjectReader with(Locale locale) {
        return this._with(this._config.with(locale));
    }

    public ObjectReader with(TimeZone timeZone) {
        return this._with(this._config.with(timeZone));
    }

    public ObjectReader withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        return this._with(this._config.withHandler(deserializationProblemHandler));
    }

    public ObjectReader with(Base64Variant base64Variant) {
        return this._with(this._config.with(base64Variant));
    }

    public ObjectReader withFormatDetection(ObjectReader ... objectReaderArray) {
        return this.withFormatDetection(new DataFormatReaders(objectReaderArray));
    }

    public ObjectReader withFormatDetection(DataFormatReaders dataFormatReaders) {
        return new ObjectReader(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader with(ContextAttributes contextAttributes) {
        DeserializationConfig deserializationConfig = this._config.with(contextAttributes);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withAttributes(Map<Object, Object> map2) {
        DeserializationConfig deserializationConfig = (DeserializationConfig)this._config.withAttributes(map2);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withAttribute(Object object, Object object2) {
        DeserializationConfig deserializationConfig = (DeserializationConfig)this._config.withAttribute(object, object2);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withoutAttribute(Object object) {
        DeserializationConfig deserializationConfig = (DeserializationConfig)this._config.withoutAttribute(object);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._config.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._parserFactory.isEnabled(feature);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    @Override
    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._parserFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public <T> T readValue(JsonParser jsonParser) throws IOException, JsonProcessingException {
        return (T)this._bind(jsonParser, this._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz2) throws IOException, JsonProcessingException {
        return this.withType(clazz2).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        return this.withType(typeReference).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.withType((JavaType)resolvedType).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType2) throws IOException, JsonProcessingException {
        return this.withType(javaType2).readValue(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz2) throws IOException, JsonProcessingException {
        return this.withType(clazz2).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        return this.withType(typeReference).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, JavaType javaType2) throws IOException, JsonProcessingException {
        return this.withType(javaType2).readValues(jsonParser);
    }

    @Override
    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException, JsonProcessingException {
        return (T)this._bindAsTree(jsonParser);
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(inputStream), this._valueToUpdate);
    }

    public <T> T readValue(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(reader), this._valueToUpdate);
    }

    public <T> T readValue(String string2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string2);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(string2), this._valueToUpdate);
    }

    public <T> T readValue(byte[] byArray) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, 0, byArray.length);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(byArray), this._valueToUpdate);
    }

    public <T> T readValue(byte[] byArray, int n, int n2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, n, n2);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(byArray, n, n2), this._valueToUpdate);
    }

    public <T> T readValue(File file) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(file)), true);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(file), this._valueToUpdate);
    }

    public <T> T readValue(URL uRL) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return (T)this._bindAndClose(this._parserFactory.createParser(uRL), this._valueToUpdate);
    }

    public <T> T readValue(JsonNode jsonNode) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(jsonNode);
        }
        return (T)this._bindAndClose(this.treeAsTokens(jsonNode), this._valueToUpdate);
    }

    public JsonNode readTree(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndCloseAsTree(inputStream);
        }
        return this._bindAndCloseAsTree(this._parserFactory.createParser(inputStream));
    }

    public JsonNode readTree(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return this._bindAndCloseAsTree(this._parserFactory.createParser(reader));
    }

    public JsonNode readTree(String string2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string2);
        }
        return this._bindAndCloseAsTree(this._parserFactory.createParser(string2));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser) throws IOException, JsonProcessingException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), false, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return this._bindAndReadValues(this._parserFactory.createParser(inputStream), this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        JsonParser jsonParser = this._parserFactory.createParser(reader);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        jsonParser.nextToken();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(String string2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string2);
        }
        JsonParser jsonParser = this._parserFactory.createParser(string2);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        jsonParser.nextToken();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(byte[] byArray, int n, int n2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(byArray, n, n2), false);
        }
        return this._bindAndReadValues(this._parserFactory.createParser(byArray), this._valueToUpdate);
    }

    public final <T> MappingIterator<T> readValues(byte[] byArray) throws IOException, JsonProcessingException {
        return this.readValues(byArray, 0, byArray.length);
    }

    public <T> MappingIterator<T> readValues(File file) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(file)), false);
        }
        return this._bindAndReadValues(this._parserFactory.createParser(file), this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(URL uRL) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return this._bindAndReadValues(this._parserFactory.createParser(uRL), this._valueToUpdate);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz2) throws JsonProcessingException {
        try {
            return this.readValue(this.treeAsTokens(treeNode), clazz2);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonProcessingException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser jsonParser, Object object) throws IOException, JsonParseException, JsonMappingException {
        Object object2;
        JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            if (object == null) {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
                object2 = this._findRootDeserializer(defaultDeserializationContext, this._valueType).getNullValue();
            } else {
                object2 = object;
            }
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object2 = object;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, this._valueType);
            if (this._unwrapRoot) {
                object2 = this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, this._valueType, jsonDeserializer);
            } else if (object == null) {
                object2 = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            } else {
                jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext, object);
                object2 = object;
            }
        }
        jsonParser.clearCurrentToken();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _bindAndClose(JsonParser jsonParser, Object object) throws IOException, JsonParseException, JsonMappingException {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        try {
            Object object2;
            Object object3;
            JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                if (object == null) {
                    object3 = this.createDeserializationContext(jsonParser, this._config);
                    object2 = this._findRootDeserializer((DeserializationContext)object3, this._valueType).getNullValue();
                } else {
                    object2 = object;
                }
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object2 = object;
            } else {
                object3 = this.createDeserializationContext(jsonParser, this._config);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer((DeserializationContext)object3, this._valueType);
                if (this._unwrapRoot) {
                    object2 = this._unwrapAndDeserialize(jsonParser, (DeserializationContext)object3, this._valueType, jsonDeserializer);
                } else if (object == null) {
                    object2 = jsonDeserializer.deserialize(jsonParser, (DeserializationContext)object3);
                } else {
                    jsonDeserializer.deserialize(jsonParser, (DeserializationContext)object3, object);
                    object2 = object;
                }
            }
            object3 = object2;
            return object3;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected JsonNode _bindAsTree(JsonParser jsonParser) throws IOException, JsonParseException, JsonMappingException {
        JsonNode jsonNode;
        JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL || jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            jsonNode = NullNode.instance;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, JSON_NODE_TYPE);
            jsonNode = this._unwrapRoot ? (JsonNode)this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, JSON_NODE_TYPE, jsonDeserializer) : (JsonNode)jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        return jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode _bindAndCloseAsTree(JsonParser jsonParser) throws IOException, JsonParseException, JsonMappingException {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        try {
            JsonNode jsonNode = this._bindAsTree(jsonParser);
            return jsonNode;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected <T> MappingIterator<T> _bindAndReadValues(JsonParser jsonParser, Object object) throws IOException, JsonProcessingException {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        jsonParser.nextToken();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    protected static JsonToken _initForReading(JsonParser jsonParser) throws IOException, JsonParseException, JsonMappingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JsonMappingException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType2) throws JsonMappingException {
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        if (javaType2 == null) {
            throw new JsonMappingException("No value type configured for ObjectReader");
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType2);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType2);
        if (jsonDeserializer == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + javaType2);
        }
        this._rootDeserializers.put(javaType2, jsonDeserializer);
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(DeserializationConfig deserializationConfig, JavaType javaType2) {
        if (javaType2 == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType2);
        if (jsonDeserializer == null) {
            try {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(null, this._config);
                jsonDeserializer = defaultDeserializationContext.findRootValueDeserializer(javaType2);
                if (jsonDeserializer != null) {
                    this._rootDeserializers.put(javaType2, jsonDeserializer);
                }
                return jsonDeserializer;
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return jsonDeserializer;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType2, JsonDeserializer<Object> jsonDeserializer) throws IOException, JsonParseException, JsonMappingException {
        Object object;
        Object object2;
        String string2 = this._config.getRootName();
        if (string2 == null) {
            object2 = this._rootNames.findRootName(javaType2, this._config);
            string2 = ((SerializedString)object2).getValue();
        }
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string2 + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            throw JsonMappingException.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string2 + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        object2 = jsonParser.getCurrentName();
        if (!string2.equals(object2)) {
            throw JsonMappingException.from(jsonParser, "Root name '" + (String)object2 + "' does not match expected ('" + string2 + "') for type " + javaType2);
        }
        jsonParser.nextToken();
        if (this._valueToUpdate == null) {
            object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        } else {
            jsonDeserializer.deserialize(jsonParser, deserializationContext, this._valueToUpdate);
            object = this._valueToUpdate;
        }
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string2 + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        return object;
    }

    protected Object _detectBindAndClose(byte[] byArray, int n, int n2) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(byArray, n, n2);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        return match.getReader()._bindAndClose(jsonParser, this._valueToUpdate);
    }

    protected Object _detectBindAndClose(DataFormatReaders.Match match, boolean bl) throws IOException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndClose(jsonParser, this._valueToUpdate);
    }

    protected <T> MappingIterator<T> _detectBindAndReadValues(DataFormatReaders.Match match, boolean bl) throws IOException, JsonProcessingException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndReadValues(jsonParser, this._valueToUpdate);
    }

    protected JsonNode _detectBindAndCloseAsTree(InputStream inputStream) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(inputStream);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return match.getReader()._bindAndCloseAsTree(jsonParser);
    }

    protected void _reportUnkownFormat(DataFormatReaders dataFormatReaders, DataFormatReaders.Match match) throws JsonProcessingException {
        throw new JsonParseException("Can not detect format from input, does not look like any of detectable formats " + dataFormatReaders.toString(), JsonLocation.NA);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._parserFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._context.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected ObjectReader _with(DeserializationConfig deserializationConfig) {
        if (deserializationConfig == this._config) {
            return this;
        }
        if (this._dataFormatReaders != null) {
            return new ObjectReader(this, deserializationConfig).withFormatDetection(this._dataFormatReaders.with(deserializationConfig));
        }
        return new ObjectReader(this, deserializationConfig);
    }

    protected void _reportUndetectableSource(Object object) throws JsonProcessingException {
        throw new JsonParseException("Can not use source of type " + object.getClass().getName() + " with format auto-detection: must be byte- not char-based", JsonLocation.NA);
    }

    protected InputStream _inputStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    protected InputStream _inputStream(File file) throws IOException {
        return new FileInputStream(file);
    }
}

