/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements Serializable {
    private static final long serialVersionUID = -3010349050434697698L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map2) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._backRefProperties = map2;
        Class<Object> clazz2 = this._baseType.getRawClass();
        this._acceptString = clazz2.isAssignableFrom(String.class);
        this._acceptBoolean = clazz2 == Boolean.TYPE || clazz2.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz2 == Integer.TYPE || clazz2.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz2 == Double.TYPE || clazz2.isAssignableFrom(Double.class);
    }

    protected AbstractDeserializer(BeanDescription beanDescription) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = null;
        this._backRefProperties = null;
        Class<Object> clazz2 = this._baseType.getRawClass();
        this._acceptString = clazz2.isAssignableFrom(String.class);
        this._acceptBoolean = clazz2 == Boolean.TYPE || clazz2.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz2 == Integer.TYPE || clazz2.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz2 == Double.TYPE || clazz2.isAssignableFrom(Double.class);
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDescription) {
        return new AbstractDeserializer(beanDescription);
    }

    @Override
    public Class<?> handledType() {
        return this._baseType.getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String string2) {
        return this._backRefProperties == null ? null : this._backRefProperties.get(string2);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        Object object;
        if (this._objectIdReader != null && (object = jsonParser.getCurrentToken()) != null && ((JsonToken)((Object)object)).isScalarValue()) {
            return this._deserializeFromObjectId(jsonParser, deserializationContext);
        }
        object = this._deserializeIfNatural(jsonParser, deserializationContext);
        if (object != null) {
            return object;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        throw deserializationContext.instantiationException(this._baseType.getRawClass(), "abstract types either need to be mapped to concrete types, have custom deserializer, or be instantiated with additional type information");
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken.isScalarValue()) {
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._acceptString) {
                    return jsonParser.getText();
                }
            } else if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                if (this._acceptInt) {
                    return jsonParser.getIntValue();
                }
            } else if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                if (this._acceptDouble) {
                    return jsonParser.getDoubleValue();
                }
            } else if (jsonToken == JsonToken.VALUE_TRUE) {
                if (this._acceptBoolean) {
                    return Boolean.TRUE;
                }
            } else if (jsonToken == JsonToken.VALUE_FALSE && this._acceptBoolean) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object = this._objectIdReader.readObjectReference(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator);
        Object object2 = readableObjectId.item;
        if (object2 == null) {
            throw new IllegalStateException("Could not resolve Object Id [" + object + "] -- unresolved forward-reference?");
        }
        return object2;
    }
}

