/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BeanPropertyMap
implements Iterable<SettableBeanProperty>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Bucket[] _buckets;
    private final int _hashMask;
    private final int _size;
    private int _nextBucketIndex = 0;

    public BeanPropertyMap(Collection<SettableBeanProperty> collection) {
        this._size = collection.size();
        int n = BeanPropertyMap.findSize(this._size);
        this._hashMask = n - 1;
        Bucket[] bucketArray = new Bucket[n];
        for (SettableBeanProperty settableBeanProperty : collection) {
            String string2 = settableBeanProperty.getName();
            int n2 = string2.hashCode() & this._hashMask;
            bucketArray[n2] = new Bucket(bucketArray[n2], string2, settableBeanProperty, this._nextBucketIndex++);
        }
        this._buckets = bucketArray;
    }

    private BeanPropertyMap(Bucket[] bucketArray, int n, int n2) {
        this._buckets = bucketArray;
        this._size = n;
        this._hashMask = bucketArray.length - 1;
        this._nextBucketIndex = n2;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n = this._buckets.length;
        Bucket[] bucketArray = new Bucket[n];
        System.arraycopy(this._buckets, 0, bucketArray, 0, n);
        String string2 = settableBeanProperty.getName();
        SettableBeanProperty settableBeanProperty2 = this.find(settableBeanProperty.getName());
        if (settableBeanProperty2 == null) {
            int n2 = string2.hashCode() & this._hashMask;
            bucketArray[n2] = new Bucket(bucketArray[n2], string2, settableBeanProperty, this._nextBucketIndex++);
            return new BeanPropertyMap(bucketArray, this._size + 1, this._nextBucketIndex);
        }
        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(bucketArray, n, this._nextBucketIndex);
        beanPropertyMap.replace(settableBeanProperty);
        return beanPropertyMap;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        Iterator<SettableBeanProperty> iterator2 = this.iterator();
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>();
        while (iterator2.hasNext()) {
            JsonDeserializer<Object> jsonDeserializer;
            SettableBeanProperty settableBeanProperty = iterator2.next();
            String string2 = nameTransformer.transform(settableBeanProperty.getName());
            JsonDeserializer<Object> jsonDeserializer2 = (settableBeanProperty = settableBeanProperty.withSimpleName(string2)).getValueDeserializer();
            if (jsonDeserializer2 != null && (jsonDeserializer = jsonDeserializer2.unwrappingDeserializer(nameTransformer)) != jsonDeserializer2) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
            }
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(arrayList);
    }

    public BeanPropertyMap assignIndexes() {
        int n = 0;
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                bucket.value.assignIndex(n++);
                bucket = bucket.next;
            }
        }
        return this;
    }

    private static final int findSize(int n) {
        int n2;
        int n3 = n <= 32 ? n + n : n + (n >> 2);
        for (n2 = 2; n2 < n3; n2 += n2) {
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Properties=[");
        int n = 0;
        for (SettableBeanProperty settableBeanProperty : this.getPropertiesInInsertionOrder()) {
            if (settableBeanProperty == null) continue;
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(settableBeanProperty.getName());
            stringBuilder.append('(');
            stringBuilder.append(settableBeanProperty.getType());
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return new IteratorImpl(this._buckets);
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        int n = this._nextBucketIndex;
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n];
        Bucket[] bucketArray = this._buckets;
        int n2 = bucketArray.length;
        for (int i = 0; i < n2; ++i) {
            Bucket bucket;
            Bucket bucket2 = bucket = bucketArray[i];
            while (bucket2 != null) {
                settableBeanPropertyArray[bucket2.index] = bucket2.value;
                bucket2 = bucket2.next;
            }
        }
        return settableBeanPropertyArray;
    }

    public int size() {
        return this._size;
    }

    public SettableBeanProperty find(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Can not pass null property name");
        }
        int n = string2.hashCode() & this._hashMask;
        Bucket bucket = this._buckets[n];
        if (bucket == null) {
            return null;
        }
        if (bucket.key == string2) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (bucket.key != string2) continue;
            return bucket.value;
        }
        return this._findWithEquals(string2, n);
    }

    public SettableBeanProperty find(int n) {
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                if (bucket.index == n) {
                    return bucket.value;
                }
                bucket = bucket.next;
            }
        }
        return null;
    }

    public void replace(SettableBeanProperty settableBeanProperty) {
        String string2 = settableBeanProperty.getName();
        int n = string2.hashCode() & this._buckets.length - 1;
        Bucket bucket = null;
        int n2 = -1;
        Bucket bucket2 = this._buckets[n];
        while (bucket2 != null) {
            if (n2 < 0 && bucket2.key.equals(string2)) {
                n2 = bucket2.index;
            } else {
                bucket = new Bucket(bucket, bucket2.key, bucket2.value, bucket2.index);
            }
            bucket2 = bucket2.next;
        }
        if (n2 < 0) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty + "' found, can't replace");
        }
        this._buckets[n] = new Bucket(bucket, string2, settableBeanProperty, n2);
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        String string2 = settableBeanProperty.getName();
        int n = string2.hashCode() & this._buckets.length - 1;
        Bucket bucket = null;
        boolean bl = false;
        Bucket bucket2 = this._buckets[n];
        while (bucket2 != null) {
            if (!bl && bucket2.key.equals(string2)) {
                bl = true;
            } else {
                bucket = new Bucket(bucket, bucket2.key, bucket2.value, bucket2.index);
            }
            bucket2 = bucket2.next;
        }
        if (!bl) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty + "' found, can't remove");
        }
        this._buckets[n] = bucket;
    }

    private SettableBeanProperty _findWithEquals(String string2, int n) {
        Bucket bucket = this._buckets[n];
        while (bucket != null) {
            if (string2.equals(bucket.key)) {
                return bucket.value;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private static final class IteratorImpl
    implements Iterator<SettableBeanProperty> {
        private final Bucket[] _buckets;
        private Bucket _currentBucket;
        private int _nextBucketIndex;

        public IteratorImpl(Bucket[] bucketArray) {
            this._buckets = bucketArray;
            int n = 0;
            int n2 = this._buckets.length;
            while (n < n2) {
                Bucket bucket;
                if ((bucket = this._buckets[n++]) == null) continue;
                this._currentBucket = bucket;
                break;
            }
            this._nextBucketIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this._currentBucket != null;
        }

        @Override
        public SettableBeanProperty next() {
            Bucket bucket = this._currentBucket;
            if (bucket == null) {
                throw new NoSuchElementException();
            }
            Bucket bucket2 = bucket.next;
            while (bucket2 == null && this._nextBucketIndex < this._buckets.length) {
                bucket2 = this._buckets[this._nextBucketIndex++];
            }
            this._currentBucket = bucket2;
            return bucket.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Bucket
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Bucket next;
        public final String key;
        public final SettableBeanProperty value;
        public final int index;

        public Bucket(Bucket bucket, String string2, SettableBeanProperty settableBeanProperty, int n) {
            this.next = bucket;
            this.key = string2;
            this.value = settableBeanProperty;
            this.index = n;
        }
    }
}

