/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 923268084968181479L;

    @Deprecated
    public static KeyDeserializer constructStringKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType2) {
        return StdKeyDeserializer.StringKD.forType(javaType2.getRawClass());
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer.EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType2, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer.DelegatingKD(javaType2.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType2) {
        Object t = deserializationConfig.introspect(javaType2);
        Constructor<?> constructor = ((BeanDescription)t).findSingleArgConstructor(String.class);
        if (constructor != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(constructor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(constructor);
        }
        Method method = ((BeanDescription)t).findFactoryMethod(String.class);
        if (method != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(method);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType javaType2, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz2 = javaType2.getRawClass();
        if (clazz2 == String.class || clazz2 == Object.class) {
            return StdKeyDeserializer.StringKD.forType(clazz2);
        }
        if (clazz2 == UUID.class) {
            return new StdKeyDeserializer.UuidKD();
        }
        if (clazz2.isPrimitive()) {
            clazz2 = ClassUtil.wrapperType(clazz2);
        }
        if (clazz2 == Integer.class) {
            return new StdKeyDeserializer.IntKD();
        }
        if (clazz2 == Long.class) {
            return new StdKeyDeserializer.LongKD();
        }
        if (clazz2 == Date.class) {
            return new StdKeyDeserializer.DateKD();
        }
        if (clazz2 == Calendar.class) {
            return new StdKeyDeserializer.CalendarKD();
        }
        if (clazz2 == Boolean.class) {
            return new StdKeyDeserializer.BoolKD();
        }
        if (clazz2 == Byte.class) {
            return new StdKeyDeserializer.ByteKD();
        }
        if (clazz2 == Character.class) {
            return new StdKeyDeserializer.CharKD();
        }
        if (clazz2 == Short.class) {
            return new StdKeyDeserializer.ShortKD();
        }
        if (clazz2 == Float.class) {
            return new StdKeyDeserializer.FloatKD();
        }
        if (clazz2 == Double.class) {
            return new StdKeyDeserializer.DoubleKD();
        }
        if (clazz2 == Locale.class) {
            return new StdKeyDeserializer.LocaleKD();
        }
        return null;
    }
}

