/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.io.Serializable;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String CLASS_NAME_DOM_NODE = "org.w3c.dom.Node";
    private static final String CLASS_NAME_DOM_DOCUMENT = "org.w3c.dom.Node";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType2, BeanDescription beanDescription) {
        Class<?> clazz2 = javaType2.getRawClass();
        String string2 = clazz2.getName();
        if (!string2.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(clazz2, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(clazz2, "org.w3c.dom.Node")) {
                return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String string3 = SERIALIZERS_FOR_JAVAX_XML;
        Object object = this.instantiate(string3);
        if (object == null) {
            return null;
        }
        return ((Serializers)object).findSerializer(serializationConfig, javaType2, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType2, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz2 = javaType2.getRawClass();
        String string2 = clazz2.getName();
        if (!string2.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(clazz2, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(clazz2, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT);
            }
            if (this.doesImplement(clazz2, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String string3 = DESERIALIZERS_FOR_JAVAX_XML;
        Object object = this.instantiate(string3);
        if (object == null) {
            return null;
        }
        return ((Deserializers)object).findBeanDeserializer(javaType2, deserializationConfig, beanDescription);
    }

    private Object instantiate(String string2) {
        try {
            return Class.forName(string2).newInstance();
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean doesImplement(Class<?> clazz2, String string2) {
        for (Class<?> clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3.getName().equals(string2)) {
                return true;
            }
            if (!this.hasInterface(clazz3, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(Class<?> clazz2, String string2) {
        Class<?>[] classArray;
        for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
            if (!clazz3.getName().equals(string2)) continue;
            return true;
        }
        for (Class<?> clazz3 : classArray) {
            if (!this.hasInterface(clazz3, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSupertypeStartingWith(Class<?> clazz2, String string2) {
        Class<?> clazz3;
        for (clazz3 = clazz2.getSuperclass(); clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.getName().startsWith(string2)) continue;
            return true;
        }
        for (clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!this.hasInterfaceStartingWith(clazz3, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterfaceStartingWith(Class<?> clazz2, String string2) {
        Class<?>[] classArray;
        for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
            if (!clazz3.getName().startsWith(string2)) continue;
            return true;
        }
        for (Class<?> clazz3 : classArray) {
            if (!this.hasInterfaceStartingWith(clazz3, string2)) continue;
            return true;
        }
        return false;
    }
}

