/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType javaType2, TypeFactory typeFactory) {
        super(javaType2, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz2, String string2) {
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass());
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz2) {
        return this._idFrom(object, clazz2);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String string2) {
        return this._typeFromId(string2, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string2) {
        return this._typeFromId(string2, databindContext.getTypeFactory());
    }

    protected JavaType _typeFromId(String string2, TypeFactory typeFactory) {
        if (string2.indexOf(60) > 0) {
            JavaType javaType2 = typeFactory.constructFromCanonical(string2);
            return javaType2;
        }
        try {
            Class<?> clazz2 = ClassUtil.findClass(string2);
            return typeFactory.constructSpecializedType(this._baseType, clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid type id '" + string2 + "' (for id type 'Id.class'): no such class found");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid type id '" + string2 + "' (for id type 'Id.class'): " + exception.getMessage(), exception);
        }
    }

    protected final String _idFrom(Object object, Class<?> clazz2) {
        Class<?> clazz3;
        Class<?> clazz4;
        String string2;
        if (Enum.class.isAssignableFrom(clazz2) && !clazz2.isEnum()) {
            clazz2 = clazz2.getSuperclass();
        }
        if ((string2 = clazz2.getName()).startsWith("java.util")) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumSet)object);
                string2 = TypeFactory.defaultInstance().constructCollectionType(EnumSet.class, clazz5).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz6 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz7 = Object.class;
                string2 = TypeFactory.defaultInstance().constructMapType(EnumMap.class, clazz6, clazz7).toCanonical();
            } else {
                String string3 = string2.substring(9);
                if ((string3.startsWith(".Arrays$") || string3.startsWith(".Collections$")) && string2.indexOf("List") >= 0) {
                    string2 = "java.util.ArrayList";
                }
            }
        } else if (string2.indexOf(36) >= 0 && (clazz4 = ClassUtil.getOuterClass(clazz2)) != null && ClassUtil.getOuterClass(clazz3 = this._baseType.getRawClass()) == null) {
            clazz2 = this._baseType.getRawClass();
            string2 = clazz2.getName();
        }
        return string2;
    }
}

