/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 278445030337366675L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final HashMap<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    protected TypeDeserializerBase(JavaType javaType2, TypeIdResolver typeIdResolver, String string2, boolean bl, Class<?> clazz2) {
        this._baseType = javaType2;
        this._idResolver = typeIdResolver;
        this._typePropertyName = string2;
        this._typeIdVisible = bl;
        this._deserializers = new HashMap();
        this._defaultImpl = clazz2 == null ? null : javaType2.forcedNarrowBy(clazz2);
        this._property = null;
    }

    protected TypeDeserializerBase(TypeDeserializerBase typeDeserializerBase, BeanProperty beanProperty) {
        this._baseType = typeDeserializerBase._baseType;
        this._idResolver = typeDeserializerBase._idResolver;
        this._typePropertyName = typeDeserializerBase._typePropertyName;
        this._typeIdVisible = typeDeserializerBase._typeIdVisible;
        this._deserializers = typeDeserializerBase._deserializers;
        this._defaultImpl = typeDeserializerBase._defaultImpl;
        this._defaultImplDeserializer = typeDeserializerBase._defaultImplDeserializer;
        this._property = beanProperty;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl == null ? null : this._defaultImpl.getRawClass();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; base-type:").append(this._baseType);
        stringBuilder.append("; id-resolver: ").append(this._idResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext deserializationContext, String string2) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> jsonDeserializer;
        HashMap<String, JsonDeserializer<Object>> hashMap = this._deserializers;
        synchronized (hashMap) {
            jsonDeserializer = this._deserializers.get(string2);
            if (jsonDeserializer == null) {
                JavaType javaType2 = this._idResolver instanceof TypeIdResolverBase ? ((TypeIdResolverBase)this._idResolver).typeFromId(deserializationContext, string2) : this._idResolver.typeFromId(string2);
                if (javaType2 == null) {
                    if (this._defaultImpl == null) {
                        throw deserializationContext.unknownTypeException(this._baseType, string2);
                    }
                    jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
                } else {
                    if (this._baseType != null && this._baseType.getClass() == javaType2.getClass()) {
                        javaType2 = this._baseType.narrowBy(javaType2.getRawClass());
                    }
                    jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType2, this._property);
                }
                this._deserializers.put(string2, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._defaultImpl == null) {
            if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        if (this._defaultImpl.getRawClass() == NoClass.class) {
            return NullifyingDeserializer.instance;
        }
        JavaType javaType2 = this._defaultImpl;
        synchronized (javaType2) {
            if (this._defaultImplDeserializer == null) {
                this._defaultImplDeserializer = deserializationContext.findContextualValueDeserializer(this._defaultImpl, this._property);
            }
            return this._defaultImplDeserializer;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> jsonDeserializer;
        Object object = jsonParser.getTypeId();
        if (object == null) {
            if (this._defaultImpl == null) throw deserializationContext.mappingException("No (native) type id found when one was expected for polymorphic type handling");
            jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
            return jsonDeserializer.deserialize(jsonParser, deserializationContext);
        } else {
            String string2 = object instanceof String ? (String)object : String.valueOf(object);
            jsonDeserializer = this._findDeserializer(deserializationContext, string2);
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }
}

