/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.util.Collection;
import java.util.HashMap;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final HashMap<String, String> _typeToId;
    protected final HashMap<String, JavaType> _idToType;

    protected TypeNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType2, HashMap<String, String> hashMap, HashMap<String, JavaType> hashMap2) {
        super(javaType2, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = hashMap;
        this._idToType = hashMap2;
    }

    public static TypeNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType2, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (bl == bl2) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> hashMap = null;
        HashMap<String, JavaType> hashMap2 = null;
        if (bl) {
            hashMap = new HashMap<String, String>();
        }
        if (bl2) {
            hashMap2 = new HashMap<String, JavaType>();
        }
        if (collection != null) {
            for (NamedType namedType : collection) {
                JavaType javaType3;
                String string2;
                Class<?> clazz2 = namedType.getType();
                String string3 = string2 = namedType.hasName() ? namedType.getName() : TypeNameIdResolver._defaultTypeId(clazz2);
                if (bl) {
                    hashMap.put(clazz2.getName(), string2);
                }
                if (!bl2 || (javaType3 = hashMap2.get(string2)) != null && clazz2.isAssignableFrom(javaType3.getRawClass())) continue;
                hashMap2.put(string2, mapperConfig.constructType(clazz2));
            }
        }
        return new TypeNameIdResolver(mapperConfig, javaType2, hashMap, hashMap2);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String idFromValue(Object object) {
        String string2;
        Class<?> clazz2 = this._typeFactory.constructType(object.getClass()).getRawClass();
        String string3 = clazz2.getName();
        HashMap<String, String> hashMap = this._typeToId;
        synchronized (hashMap) {
            string2 = this._typeToId.get(string3);
            if (string2 == null) {
                if (this._config.isAnnotationProcessingEnabled()) {
                    BeanDescription beanDescription = this._config.introspectClassAnnotations(clazz2);
                    string2 = this._config.getAnnotationIntrospector().findTypeName(beanDescription.getClassInfo());
                }
                if (string2 == null) {
                    string2 = TypeNameIdResolver._defaultTypeId(clazz2);
                }
                this._typeToId.put(string3, string2);
            }
        }
        return string2;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz2) {
        if (object == null) {
            return null;
        }
        return this.idFromValue(object);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String string2) {
        return this._typeFromId(string2);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string2) {
        return this._typeFromId(string2);
    }

    protected JavaType _typeFromId(String string2) {
        return this._idToType.get(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; id-to-type=").append(this._idToType);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected static String _defaultTypeId(Class<?> clazz2) {
        String string2 = clazz2.getName();
        int n = string2.lastIndexOf(46);
        return n < 0 ? string2 : string2.substring(n + 1);
    }
}

