/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ClassKey;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class SimpleAbstractTypeResolver
extends AbstractTypeResolver
implements Serializable {
    private static final long serialVersionUID = 8635483102371490919L;
    protected final HashMap<ClassKey, Class<?>> _mappings = new HashMap();

    public <T> SimpleAbstractTypeResolver addMapping(Class<T> clazz2, Class<? extends T> clazz3) {
        if (clazz2 == clazz3) {
            throw new IllegalArgumentException("Can not add mapping from class to itself");
        }
        if (!clazz2.isAssignableFrom(clazz3)) {
            throw new IllegalArgumentException("Can not add mapping from class " + clazz2.getName() + " to " + clazz3.getName() + ", as latter is not a subtype of former");
        }
        if (!Modifier.isAbstract(clazz2.getModifiers())) {
            throw new IllegalArgumentException("Can not add mapping from class " + clazz2.getName() + " since it is not abstract");
        }
        this._mappings.put(new ClassKey(clazz2), clazz3);
        return this;
    }

    @Override
    public JavaType findTypeMapping(DeserializationConfig deserializationConfig, JavaType javaType2) {
        Class<?> clazz2 = javaType2.getRawClass();
        Class<?> clazz3 = this._mappings.get(new ClassKey(clazz2));
        if (clazz3 == null) {
            return null;
        }
        return javaType2.narrowBy(clazz3);
    }

    @Override
    public JavaType resolveAbstractType(DeserializationConfig deserializationConfig, JavaType javaType2) {
        return null;
    }
}

