/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

@JacksonStdImpl
public class EnumMapSerializer
extends ContainerSerializer<EnumMap<? extends Enum<?>, ?>>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final BeanProperty _property;
    protected final EnumValues _keyEnums;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    public EnumMapSerializer(JavaType javaType2, boolean bl, EnumValues enumValues, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(EnumMap.class, false);
        this._property = null;
        this._staticTyping = bl || javaType2 != null && javaType2.isFinal();
        this._valueType = javaType2;
        this._keyEnums = enumValues;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer(EnumMapSerializer enumMapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        super(enumMapSerializer);
        this._property = beanProperty;
        this._staticTyping = enumMapSerializer._staticTyping;
        this._valueType = enumMapSerializer._valueType;
        this._keyEnums = enumMapSerializer._keyEnums;
        this._valueTypeSerializer = enumMapSerializer._valueTypeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new EnumMapSerializer(this._valueType, this._staticTyping, this._keyEnums, typeSerializer, this._valueSerializer);
    }

    public EnumMapSerializer withValueSerializer(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        if (this._property == beanProperty && jsonSerializer == this._valueSerializer) {
            return this;
        }
        return new EnumMapSerializer(this, beanProperty, jsonSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            if (this._staticTyping) {
                return this.withValueSerializer(beanProperty, serializerProvider.findValueSerializer(this._valueType, beanProperty));
            }
        } else {
            jsonSerializer = serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty);
        }
        if (jsonSerializer != this._valueSerializer) {
            return this.withValueSerializer(beanProperty, jsonSerializer);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap == null || enumMap.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap.size() == 1;
    }

    @Override
    public void serialize(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(enumMap, jsonGenerator);
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(enumMap, jsonGenerator);
    }

    protected void serializeContents(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._valueSerializer != null) {
            this.serializeContentsUsing(enumMap, jsonGenerator, serializerProvider, this._valueSerializer);
            return;
        }
        JsonSerializer<Object> jsonSerializer = null;
        Class<?> clazz2 = null;
        EnumValues enumValues = this._keyEnums;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry2 : enumMap.entrySet()) {
            JsonSerializer<Object> jsonSerializer2;
            Class<?> clazz3;
            Object obj = entry2.getValue();
            if (bl && obj == null) continue;
            Enum<?> enum_ = entry2.getKey();
            if (enumValues == null) {
                clazz3 = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)((Object)clazz3)).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            clazz3 = obj.getClass();
            if (clazz3 == clazz2) {
                jsonSerializer2 = jsonSerializer;
            } else {
                jsonSerializer = jsonSerializer2 = serializerProvider.findValueSerializer(clazz3, this._property);
                clazz2 = clazz3;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer2.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry2.getKey().name());
            }
        }
    }

    protected void serializeContentsUsing(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        EnumValues enumValues = this._keyEnums;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry2 : enumMap.entrySet()) {
            Object obj = entry2.getValue();
            if (bl && obj == null) continue;
            Enum<?> enum_ = entry2.getKey();
            if (enumValues == null) {
                StdSerializer stdSerializer = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)stdSerializer).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry2.getKey().name());
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Type[] typeArray;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length == 2) {
            JavaType javaType2 = serializerProvider.constructType(typeArray[0]);
            JavaType javaType3 = serializerProvider.constructType(typeArray[1]);
            ObjectNode objectNode2 = JsonNodeFactory.instance.objectNode();
            Class<?> clazz2 = javaType2.getRawClass();
            for (Enum enum_ : (Enum[])clazz2.getEnumConstants()) {
                JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(javaType3.getRawClass(), this._property);
                JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null) : JsonSchema.getDefaultSchemaNode();
                objectNode2.put(serializerProvider.getConfig().getAnnotationIntrospector().findEnumValue(enum_), jsonNode);
            }
            objectNode.put("properties", objectNode2);
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType2) throws JsonMappingException {
        EnumValues enumValues;
        if (jsonFormatVisitorWrapper == null) {
            return;
        }
        JsonObjectFormatVisitor jsonObjectFormatVisitor = jsonFormatVisitorWrapper.expectObjectFormat(javaType2);
        if (jsonObjectFormatVisitor == null) {
            return;
        }
        JavaType javaType3 = javaType2.containedType(1);
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && javaType3 != null) {
            jsonSerializer = jsonFormatVisitorWrapper.getProvider().findValueSerializer(javaType3, this._property);
        }
        if (javaType3 == null) {
            javaType3 = jsonFormatVisitorWrapper.getProvider().constructType((Type)((Object)Object.class));
        }
        if ((enumValues = this._keyEnums) == null) {
            JavaType javaType4 = javaType2.containedType(0);
            if (javaType4 == null) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + javaType2);
            }
            JsonSerializer<Object> jsonSerializer2 = jsonFormatVisitorWrapper.getProvider().findValueSerializer(javaType4, this._property);
            if (!(jsonSerializer2 instanceof EnumSerializer)) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + javaType2);
            }
            enumValues = ((EnumSerializer)jsonSerializer2).getEnumValues();
        }
        for (Map.Entry entry2 : enumValues.internalMap().entrySet()) {
            String string2 = ((SerializedString)entry2.getValue()).getValue();
            if (jsonSerializer == null) {
                jsonSerializer = jsonFormatVisitorWrapper.getProvider().findValueSerializer(entry2.getKey().getClass(), this._property);
            }
            jsonObjectFormatVisitor.property(string2, jsonSerializer, javaType3);
        }
    }
}

