/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import java.util.Map;

public class MapLikeType
extends TypeBase {
    private static final long serialVersionUID = 416067702302823522L;
    protected final JavaType _keyType;
    protected final JavaType _valueType;

    protected MapLikeType(Class<?> clazz2, JavaType javaType2, JavaType javaType3, Object object, Object object2, boolean bl) {
        super(clazz2, javaType2.hashCode() ^ javaType3.hashCode(), object, object2, bl);
        this._keyType = javaType2;
        this._valueType = javaType3;
    }

    public static MapLikeType construct(Class<?> clazz2, JavaType javaType2, JavaType javaType3) {
        return new MapLikeType(clazz2, javaType2, javaType3, null, null, false);
    }

    @Override
    protected JavaType _narrow(Class<?> clazz2) {
        return new MapLikeType(clazz2, this._keyType, this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> clazz2) {
        if (clazz2 == this._valueType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType, this._valueType.narrowBy(clazz2), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType widenContentsBy(Class<?> clazz2) {
        if (clazz2 == this._valueType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType, this._valueType.widenBy(clazz2), this._valueHandler, this._typeHandler, this._asStatic);
    }

    public JavaType narrowKey(Class<?> clazz2) {
        if (clazz2 == this._keyType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType.narrowBy(clazz2), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    public JavaType widenKey(Class<?> clazz2) {
        if (clazz2 == this._keyType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType.widenBy(clazz2), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType, this._valueHandler, object, this._asStatic);
    }

    @Override
    public MapLikeType withContentTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType.withTypeHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType, object, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withContentValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType.withValueHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType, this._valueType.withStaticTyping(), this._valueHandler, this._typeHandler, true);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._keyType != null) {
            stringBuilder.append('<');
            stringBuilder.append(this._keyType.toCanonical());
            stringBuilder.append(',');
            stringBuilder.append(this._valueType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public boolean isMapLikeType() {
        return true;
    }

    @Override
    public JavaType getKeyType() {
        return this._keyType;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public int containedTypeCount() {
        return 2;
    }

    @Override
    public JavaType containedType(int n) {
        if (n == 0) {
            return this._keyType;
        }
        if (n == 1) {
            return this._valueType;
        }
        return null;
    }

    @Override
    public String containedTypeName(int n) {
        if (n == 0) {
            return "K";
        }
        if (n == 1) {
            return "V";
        }
        return null;
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return MapLikeType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        MapLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._keyType.getGenericSignature(stringBuilder);
        this._valueType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    public MapLikeType withKeyTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType.withTypeHandler(object), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    public MapLikeType withKeyValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType.withValueHandler(object), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    public boolean isTrueMapType() {
        return Map.class.isAssignableFrom(this._class);
    }

    @Override
    public String toString() {
        return "[map-like type; class " + this._class.getName() + ", " + this._keyType + " -> " + this._valueType + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MapLikeType mapLikeType = (MapLikeType)object;
        return this._class == mapLikeType._class && this._keyType.equals(mapLikeType._keyType) && this._valueType.equals(mapLikeType._valueType);
    }
}

