/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EnumResolver<T extends Enum<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<T> _enumClass;
    protected final T[] _enums;
    protected final HashMap<String, T> _enumsById;

    protected EnumResolver(Class<T> clazz2, T[] TArray, HashMap<String, T> hashMap) {
        this._enumClass = clazz2;
        this._enums = TArray;
        this._enumsById = hashMap;
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructFor(Class<ET> clazz2, AnnotationIntrospector annotationIntrospector) {
        Enum[] enumArray = (Enum[])clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz2.getName());
        }
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        for (Enum enum_ : enumArray) {
            hashMap.put(annotationIntrospector.findEnumValue(enum_), enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingToString(Class<ET> clazz2) {
        Enum[] enumArray = (Enum[])clazz2.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n = enumArray.length;
        while (--n >= 0) {
            Enum enum_ = enumArray[n];
            hashMap.put(enum_.toString(), enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingMethod(Class<ET> clazz2, Method method) {
        Enum[] enumArray = (Enum[])clazz2.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n = enumArray.length;
        while (--n >= 0) {
            Enum enum_ = enumArray[n];
            try {
                Object object = method.invoke((Object)enum_, new Object[0]);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap);
    }

    public static EnumResolver<?> constructUnsafe(Class<?> clazz2, AnnotationIntrospector annotationIntrospector) {
        Class<?> clazz3 = clazz2;
        return EnumResolver.constructFor(clazz3, annotationIntrospector);
    }

    public static EnumResolver<?> constructUnsafeUsingToString(Class<?> clazz2) {
        Class<?> clazz3 = clazz2;
        return EnumResolver.constructUsingToString(clazz3);
    }

    public static EnumResolver<?> constructUnsafeUsingMethod(Class<?> clazz2, Method method) {
        Class<?> clazz3 = clazz2;
        return EnumResolver.constructUsingMethod(clazz3, method);
    }

    public T findEnum(String string2) {
        return (T)((Enum)this._enumsById.get(string2));
    }

    public T getEnum(int n) {
        if (n < 0 || n >= this._enums.length) {
            return null;
        }
        return this._enums[n];
    }

    public List<T> getEnums() {
        ArrayList<T> arrayList = new ArrayList<T>(this._enums.length);
        for (T t : this._enums) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public Class<T> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

