/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Duration;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TokenBucket;
import com.twitter.util.TokenBucket$;
import com.twitter.util.WindowedAdder;
import com.twitter.util.WindowedAdder$;
import scala.Function0;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class TokenBucket$ {
    public static final TokenBucket$ MODULE$;

    static {
        new TokenBucket$();
    }

    public TokenBucket newBoundedBucket(long limit) {
        return new TokenBucket(limit){
            private long counter;
            private final long limit$1;

            public void put(int n) {
                Predef$.MODULE$.require(n >= 0);
                anon.1 var2_2 = this;
                synchronized (var2_2) {
                    this.counter = package$.MODULE$.min(this.counter + (long)n, this.limit$1);
                    return;
                }
            }

            public boolean tryGet(int n) {
                Predef$.MODULE$.require(n >= 0);
                anon.1 var2_2 = this;
                synchronized (var2_2) {
                    boolean ok;
                    boolean bl = ok = this.counter >= (long)n;
                    if (ok) {
                        this.counter -= (long)n;
                    }
                    Boolean bl2 = BoxesRunTime.boxToBoolean(ok);
                    return BoxesRunTime.unboxToBoolean(bl2);
                }
            }

            public synchronized long count() {
                return this.counter;
            }
            {
                this.limit$1 = limit$1;
                this.counter = 0L;
            }
        };
    }

    public TokenBucket newLeakyBucket(Duration ttl, int reserve, Function0<Object> nowMs) {
        return new TokenBucket(ttl, reserve, nowMs){
            private final WindowedAdder w;
            private final int reserve$1;

            public void put(int n) {
                Predef$.MODULE$.require(n >= 0);
                this.w.add(n);
            }

            public boolean tryGet(int n) {
                Predef$.MODULE$.require(n >= 0);
                anon.2 var2_2 = this;
                synchronized (var2_2) {
                    boolean ok;
                    boolean bl = ok = this.count() >= (long)n;
                    if (ok) {
                        this.w.add(-n);
                    }
                    Boolean bl2 = BoxesRunTime.boxToBoolean(ok);
                    return BoxesRunTime.unboxToBoolean(bl2);
                }
            }

            public long count() {
                return this.w.sum() + (long)this.reserve$1;
            }
            {
                this.reserve$1 = reserve$1;
                this.w = WindowedAdder$.MODULE$.apply(ttl$1.inMilliseconds(), 10, nowMs$1);
            }
        };
    }

    public TokenBucket newLeakyBucket(Duration ttl, int reserve) {
        return this.newLeakyBucket(ttl, reserve, Stopwatch$.MODULE$.systemMillis());
    }

    private TokenBucket$() {
        MODULE$ = this;
    }
}

