'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// get current working directory
var cwd = process.cwd();
// define user javascript config file path
var ujcFilePath = _path2.default.resolve(cwd, 'metarpheus-config.js');

// define ujc
require('babel-register')({
  only: ujcFilePath // so that config file can be ESwhatever
});
// TODO: fs.existsSync is deprecated
var ujc = _fs2.default.existsSync(ujcFilePath) && require(ujcFilePath) || {};

// default module prelude
var modelPrelude = '// DO NOT EDIT MANUALLY - metarpheus-generated\n/* eslint-disable */\nimport t from \'tcomb\';\n';

exports.default = _extends({
  apiPath: _path2.default.resolve(cwd, '../api/src/main/scala'),
  modelPrelude: modelPrelude,
  apiPrelude: modelPrelude + '\nimport * as m from \'./model\';\n',
  apiModelPrefix: 'm.',
  modelOut: _path2.default.resolve(cwd, 'src/app/metarpheus/model.js'),
  apiOut: _path2.default.resolve(cwd, 'src/app/metarpheus/api.js'),
  intermRepIn: _path2.default.resolve(__dirname, 'metarpheus-interm-rep.json')
}, ujc, {
  overrides: _extends({
    Date: function Date() {
      return 't.Date';
    },
    DateTime: function DateTime() {
      return 't.Date';
    },
    LocalDate: function LocalDate() {
      return 't.Date';
    }, // TODO(gio): fixme? this should be a date only
    OffsetDateTime: function OffsetDateTime() {
      return 't.Date';
    }, // TODO(gio): this allows milliseconds and more, parsing should be fixed
    Map: function Map() {
      return 't.Object';
    }
  }, ujc.overrides)
});