'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = download;

var _request = require('request');

var _request2 = _interopRequireDefault(_request);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _util = require('../../util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable max-len */
var METARPEUS_URL = 'https://github.com/buildo/metarpheus/releases/download/0.1.0-escalapio/metarpheus.jar';
/* eslint-enable max-len */

function download() {
  var metarpheusPath = __dirname + '/metarpheus.jar';
  var file = _fs2.default.createWriteStream(metarpheusPath);

  file.on('close', function () {
    _util.logger.metarpheus('File downloaded at: ' + metarpheusPath);
  });

  _util.logger.metarpheus('Downloading metarpheus jar...');
  _request2.default.get(METARPEUS_URL).on('response', function (response) {
    if (response.statusCode === 404) {
      throw new Error(METARPEUS_URL + ' not found!');
    }
  }).on('error', function (err) {
    return _util.logger.metarpheus(err);
  }).pipe(file);
}