'use strict';

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _child_process = require('child_process');

var _util = require('../../util');

var _config = require('./config');

var _config2 = _interopRequireDefault(_config);

var _metarpheusTcomb2 = require('metarpheus-tcomb');

var _metarpheusTcomb3 = _interopRequireDefault(_metarpheusTcomb2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cwd = process.cwd();

// METARPHEUS
// define user scala configuration (usc) file path
var uscFilePath = _path2.default.resolve(cwd, './metarpheus-config.scala');
// set config (cfg) to usc file path if exists, otherwise fallback on default config
var defaultScalaConfig = _path2.default.resolve(__dirname, '../../../src/scripts/metarpheus/config.scala');
// TODO: fs.existsSync is deprecated
var cfg = _fs2.default.existsSync(uscFilePath) && uscFilePath || defaultScalaConfig;
// define output (otp) file path
var otp = _path2.default.resolve(__dirname, './metarpheus-interm-rep.json');
// compose metarpheus command
var metarpheusJar = _path2.default.resolve(__dirname, 'metarpheus.jar');
var metarpheusCmd = 'java -jar ' + metarpheusJar + ' --config=' + cfg + ' --output=' + otp + ' ../api/src/main/scala'; //eslint-disable-line max-len

// exec cmd syncronously
_util.logger.metarpheus('Starting ' + metarpheusCmd);
(0, _child_process.execSync)(metarpheusCmd);
_util.logger.metarpheus('Finished ' + metarpheusCmd);

// METARPHEUS-TCOMB
_util.logger.metarpheus('Starting metarpheus-tcomb', _config2.default);
var overrides = _config2.default.overrides;
var modelPrelude = _config2.default.modelPrelude;
var apiPrelude = _config2.default.apiPrelude;
var apiModelPrefix = _config2.default.apiModelPrefix;
var renameModel = _config2.default.renameModel;
// use metarpheus-tcomb node api to generate model and api

var _metarpheusTcomb = (0, _metarpheusTcomb3.default)({
  intermRep: require(_config2.default.intermRepIn),
  config: {
    overrides: overrides,
    modelPrelude: modelPrelude,
    apiPrelude: apiPrelude,
    apiModelPrefix: apiModelPrefix,
    renameModel: renameModel
  }
});

var model = _metarpheusTcomb.model;
var api = _metarpheusTcomb.api;

_util.logger.metarpheus('Finished metarpheus-tcomb');

// write api in api output file
_util.logger.metarpheus('Writing ' + _config2.default.apiOut);
_fs2.default.writeFileSync(_config2.default.apiOut, api);
_util.logger.metarpheus('Finished!');

// write model in model output file
_util.logger.metarpheus('Writing ' + _config2.default.modelOut);
_fs2.default.writeFileSync(_config2.default.modelOut, model);
_util.logger.metarpheus('Finished!');