/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.lang.ref.SoftReference;

public final class JsonStringEncoder {
    private static final char[] HEX_CHARS = CharTypes.copyHexChars();
    private static final byte[] HEX_BYTES = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    private static final int INT_BACKSLASH = 92;
    private static final int INT_U = 117;
    private static final int INT_0 = 48;
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _threadEncoder = new ThreadLocal();
    protected TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteBuilder;
    protected final char[] _quoteBuffer = new char[6];

    public JsonStringEncoder() {
        this._quoteBuffer[0] = 92;
        this._quoteBuffer[2] = 48;
        this._quoteBuffer[3] = 48;
    }

    public static JsonStringEncoder getInstance() {
        JsonStringEncoder jsonStringEncoder;
        SoftReference<JsonStringEncoder> softReference = _threadEncoder.get();
        JsonStringEncoder jsonStringEncoder2 = jsonStringEncoder = softReference == null ? null : softReference.get();
        if (jsonStringEncoder == null) {
            jsonStringEncoder = new JsonStringEncoder();
            _threadEncoder.set(new SoftReference<JsonStringEncoder>(jsonStringEncoder));
        }
        return jsonStringEncoder;
    }

    public char[] quoteAsString(String string2) {
        TextBuffer textBuffer = this._textBuffer;
        if (textBuffer == null) {
            this._textBuffer = textBuffer = new TextBuffer(null);
        }
        char[] cArray = textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n = nArray.length;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        block0: while (n2 < n3) {
            int n5;
            int n6;
            char c;
            while ((c = string2.charAt(n2)) >= n || nArray[c] == 0) {
                if (n4 >= cArray.length) {
                    cArray = textBuffer.finishCurrentSegment();
                    n4 = 0;
                }
                cArray[n4++] = c;
                if (++n2 < n3) continue;
                break block0;
            }
            int n7 = n6 = (n5 = nArray[c = string2.charAt(n2++)]) < 0 ? this._appendNumericEscape(c, this._quoteBuffer) : this._appendNamedEscape(n5, this._quoteBuffer);
            if (n4 + n6 > cArray.length) {
                int n8 = cArray.length - n4;
                if (n8 > 0) {
                    System.arraycopy(this._quoteBuffer, 0, cArray, n4, n8);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n9 = n6 - n8;
                System.arraycopy(this._quoteBuffer, n8, cArray, 0, n9);
                n4 = n9;
                continue;
            }
            System.arraycopy(this._quoteBuffer, 0, cArray, n4, n6);
            n4 += n6;
        }
        textBuffer.setCurrentLength(n4);
        return textBuffer.contentsAsArray();
    }

    public byte[] quoteAsUTF8(String string2) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        block0: while (n < n2) {
            int n4;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n4 = string2.charAt(n)) <= 127 && nArray[n4] == 0) {
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)n4;
                if (++n < n2) continue;
                break block0;
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            if ((n4 = string2.charAt(n++)) <= 127) {
                int n5 = nArray[n4];
                n3 = this._appendByteEscape(n4, n5, byteArrayBuilder, n3);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n4 <= 2047) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                n4 = 0x80 | n4 & 0x3F;
            } else if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            } else {
                if (n4 > 56319) {
                    JsonStringEncoder._illegalSurrogate(n4);
                }
                if (n >= n2) {
                    JsonStringEncoder._illegalSurrogate(n4);
                }
                if ((n4 = JsonStringEncoder._convertSurrogate(n4, string2.charAt(n++))) > 0x10FFFF) {
                    JsonStringEncoder._illegalSurrogate(n4);
                }
                byArray[n3++] = (byte)(0xF0 | n4 >> 18);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            byArray[n3++] = (byte)n4;
        }
        return this._byteBuilder.completeAndCoalesce(n3);
    }

    public byte[] encodeAsUTF8(String string2) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        int n4 = byArray.length;
        block0: while (n < n2) {
            int n5 = string2.charAt(n++);
            while (n5 <= 127) {
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)n5;
                if (n >= n2) break block0;
                n5 = string2.charAt(n++);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            if (n5 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            } else {
                if (n5 > 56319) {
                    JsonStringEncoder._illegalSurrogate(n5);
                }
                if (n >= n2) {
                    JsonStringEncoder._illegalSurrogate(n5);
                }
                if ((n5 = JsonStringEncoder._convertSurrogate(n5, string2.charAt(n++))) > 0x10FFFF) {
                    JsonStringEncoder._illegalSurrogate(n5);
                }
                byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
        }
        return this._byteBuilder.completeAndCoalesce(n3);
    }

    private int _appendNumericEscape(int n, char[] cArray) {
        cArray[1] = 117;
        cArray[4] = HEX_CHARS[n >> 4];
        cArray[5] = HEX_CHARS[n & 0xF];
        return 6;
    }

    private int _appendNamedEscape(int n, char[] cArray) {
        cArray[1] = (char)n;
        return 2;
    }

    private int _appendByteEscape(int n, int n2, ByteArrayBuilder byteArrayBuilder, int n3) {
        byteArrayBuilder.setCurrentSegmentLength(n3);
        byteArrayBuilder.append(92);
        if (n2 < 0) {
            byteArrayBuilder.append(117);
            if (n > 255) {
                int n4 = n >> 8;
                byteArrayBuilder.append(HEX_BYTES[n4 >> 4]);
                byteArrayBuilder.append(HEX_BYTES[n4 & 0xF]);
                n &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HEX_BYTES[n >> 4]);
            byteArrayBuilder.append(HEX_BYTES[n & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n2);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    protected static int _convertSurrogate(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n - 55296 << 10) + (n2 - 56320);
    }

    protected static void _illegalSurrogate(int n) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(n));
    }
}

