/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.type.ResolvedType;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public abstract class JavaType
extends ResolvedType
implements Serializable,
Type {
    private static final long serialVersionUID = 6774285981275451126L;
    protected final Class<?> _class;
    protected final int _hashCode;
    protected final Object _valueHandler;
    protected final Object _typeHandler;
    protected final boolean _asStatic;

    protected JavaType(Class<?> clazz2, int n, Object object, Object object2, boolean bl) {
        this._class = clazz2;
        this._hashCode = clazz2.getName().hashCode() + n;
        this._valueHandler = object;
        this._typeHandler = object2;
        this._asStatic = bl;
    }

    public abstract JavaType withTypeHandler(Object var1);

    public abstract JavaType withContentTypeHandler(Object var1);

    public abstract JavaType withValueHandler(Object var1);

    public abstract JavaType withContentValueHandler(Object var1);

    public abstract JavaType withStaticTyping();

    public JavaType narrowBy(Class<?> clazz2) {
        if (clazz2 == this._class) {
            return this;
        }
        this._assertSubclass(clazz2, this._class);
        JavaType javaType2 = this._narrow(clazz2);
        if (this._valueHandler != javaType2.getValueHandler()) {
            javaType2 = javaType2.withValueHandler(this._valueHandler);
        }
        if (this._typeHandler != javaType2.getTypeHandler()) {
            javaType2 = javaType2.withTypeHandler(this._typeHandler);
        }
        return javaType2;
    }

    public JavaType forcedNarrowBy(Class<?> clazz2) {
        if (clazz2 == this._class) {
            return this;
        }
        JavaType javaType2 = this._narrow(clazz2);
        if (this._valueHandler != javaType2.getValueHandler()) {
            javaType2 = javaType2.withValueHandler(this._valueHandler);
        }
        if (this._typeHandler != javaType2.getTypeHandler()) {
            javaType2 = javaType2.withTypeHandler(this._typeHandler);
        }
        return javaType2;
    }

    public JavaType widenBy(Class<?> clazz2) {
        if (clazz2 == this._class) {
            return this;
        }
        this._assertSubclass(this._class, clazz2);
        return this._widen(clazz2);
    }

    protected abstract JavaType _narrow(Class<?> var1);

    protected JavaType _widen(Class<?> clazz2) {
        return this._narrow(clazz2);
    }

    public abstract JavaType narrowContentsBy(Class<?> var1);

    public abstract JavaType widenContentsBy(Class<?> var1);

    @Override
    public final Class<?> getRawClass() {
        return this._class;
    }

    @Override
    public final boolean hasRawClass(Class<?> clazz2) {
        return this._class == clazz2;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    @Override
    public boolean isConcrete() {
        int n = this._class.getModifiers();
        if ((n & 0x600) == 0) {
            return true;
        }
        return this._class.isPrimitive();
    }

    @Override
    public boolean isThrowable() {
        return Throwable.class.isAssignableFrom(this._class);
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public final boolean isEnumType() {
        return this._class.isEnum();
    }

    @Override
    public final boolean isInterface() {
        return this._class.isInterface();
    }

    @Override
    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal(this._class.getModifiers());
    }

    @Override
    public abstract boolean isContainerType();

    @Override
    public boolean isCollectionLikeType() {
        return false;
    }

    @Override
    public boolean isMapLikeType() {
        return false;
    }

    public final boolean useStaticType() {
        return this._asStatic;
    }

    @Override
    public boolean hasGenericTypes() {
        return this.containedTypeCount() > 0;
    }

    @Override
    public JavaType getKeyType() {
        return null;
    }

    @Override
    public JavaType getContentType() {
        return null;
    }

    @Override
    public int containedTypeCount() {
        return 0;
    }

    @Override
    public JavaType containedType(int n) {
        return null;
    }

    @Override
    public String containedTypeName(int n) {
        return null;
    }

    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    public String getGenericSignature() {
        StringBuilder stringBuilder = new StringBuilder(40);
        this.getGenericSignature(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    public String getErasedSignature() {
        StringBuilder stringBuilder = new StringBuilder(40);
        this.getErasedSignature(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    protected void _assertSubclass(Class<?> clazz2, Class<?> clazz3) {
        if (!this._class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Class " + clazz2.getName() + " is not assignable to " + this._class.getName());
        }
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }
}

