/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;

    protected DefaultDeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        super(deserializerFactory, deserializerCache);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        super(defaultDeserializationContext, deserializationConfig, jsonParser, injectableValues);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializerFactory deserializerFactory) {
        super(defaultDeserializationContext, deserializerFactory);
    }

    @Override
    public ReadableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        ReadableObjectId readableObjectId;
        ObjectIdGenerator.IdKey idKey = objectIdGenerator.key(object);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            readableObjectId = this._objectIds.get(idKey);
            if (readableObjectId != null) {
                return readableObjectId;
            }
        }
        readableObjectId = new ReadableObjectId(object);
        this._objectIds.put(idKey, readableObjectId);
        return readableObjectId;
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonDeserializer) {
            jsonDeserializer = (JsonDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + object.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class clazz2 = (Class)object;
            if (clazz2 == JsonDeserializer.None.class || clazz2 == NoClass.class) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(clazz2)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz2.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer2 = jsonDeserializer = handlerInstantiator == null ? null : handlerInstantiator.deserializerInstance(this._config, annotated, clazz2);
            if (jsonDeserializer == null) {
                jsonDeserializer = (JsonDeserializer)ClassUtil.createInstance(clazz2, this._config.canOverrideAccessModifiers());
            }
        }
        if (jsonDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(this);
        }
        return jsonDeserializer;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        KeyDeserializer keyDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof KeyDeserializer) {
            keyDeserializer = (KeyDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz2 = (Class)object;
            if (clazz2 == KeyDeserializer.None.class || clazz2 == NoClass.class) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(clazz2)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz2.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer2 = keyDeserializer = handlerInstantiator == null ? null : handlerInstantiator.keyDeserializerInstance(this._config, annotated, clazz2);
            if (keyDeserializer == null) {
                keyDeserializer = (KeyDeserializer)ClassUtil.createInstance(clazz2, this._config.canOverrideAccessModifiers());
            }
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(this);
        }
        return keyDeserializer;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory deserializerFactory) {
            super(deserializerFactory, null);
        }

        protected Impl(Impl impl2, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            super(impl2, deserializationConfig, jsonParser, injectableValues);
        }

        protected Impl(Impl impl2, DeserializerFactory deserializerFactory) {
            super(impl2, deserializerFactory);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            return new Impl(this, deserializationConfig, jsonParser, injectableValues);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory deserializerFactory) {
            return new Impl(this, deserializerFactory);
        }
    }
}

