/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import java.io.Serializable;

public final class NullProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object _nullValue;
    private final boolean _isPrimitive;
    private final Class<?> _rawType;

    public NullProvider(JavaType javaType2, Object object) {
        this._nullValue = object;
        this._isPrimitive = javaType2.isPrimitive();
        this._rawType = javaType2.getRawClass();
    }

    public Object nullValue(DeserializationContext deserializationContext) throws JsonProcessingException {
        if (this._isPrimitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            throw deserializationContext.mappingException("Can not map JSON null into type " + this._rawType.getName() + " (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)");
        }
        return this._nullValue;
    }
}

