/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static final long serialVersionUID = 1L;
    static final int[] HEX_DIGITS;
    public static final UUIDDeserializer instance;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    protected UUID _deserialize(String string2, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (string2.length() != 36) {
            if (string2.length() == 24) {
                byte[] byArray = Base64Variants.getDefaultVariant().decode(string2);
                return this._fromBytes(byArray, deserializationContext);
            }
            this._badFormat(string2);
        }
        if (string2.charAt(8) != '-' || string2.charAt(13) != '-' || string2.charAt(18) != '-' || string2.charAt(23) != '-') {
            this._badFormat(string2);
        }
        long l = UUIDDeserializer.intFromChars(string2, 0);
        long l2 = (long)UUIDDeserializer.shortFromChars(string2, 9) << 16;
        long l3 = (l <<= 32) + (l2 |= (long)UUIDDeserializer.shortFromChars(string2, 14));
        int n = UUIDDeserializer.shortFromChars(string2, 19) << 16 | UUIDDeserializer.shortFromChars(string2, 24);
        l = n;
        l2 = UUIDDeserializer.intFromChars(string2, 28);
        l2 = l2 << 32 >>> 32;
        long l4 = (l <<= 32) | l2;
        return new UUID(l3, l4);
    }

    @Override
    protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (object instanceof byte[]) {
            return this._fromBytes((byte[])object, deserializationContext);
        }
        super._deserializeEmbedded(object, deserializationContext);
        return null;
    }

    private void _badFormat(String string2) {
        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
    }

    static int intFromChars(String string2, int n) {
        return (UUIDDeserializer.byteFromChars(string2, n) << 24) + (UUIDDeserializer.byteFromChars(string2, n + 2) << 16) + (UUIDDeserializer.byteFromChars(string2, n + 4) << 8) + UUIDDeserializer.byteFromChars(string2, n + 6);
    }

    static int shortFromChars(String string2, int n) {
        return (UUIDDeserializer.byteFromChars(string2, n) << 8) + UUIDDeserializer.byteFromChars(string2, n + 2);
    }

    static int byteFromChars(String string2, int n) {
        int n2;
        char c = string2.charAt(n);
        char c2 = string2.charAt(n + 1);
        if (c <= '\u007f' && c2 <= '\u007f' && (n2 = HEX_DIGITS[c] << 4 | HEX_DIGITS[c2]) >= 0) {
            return n2;
        }
        if (c > '\u007f' || HEX_DIGITS[c] < 0) {
            return UUIDDeserializer._badChar(string2, n, c);
        }
        return UUIDDeserializer._badChar(string2, n + 1, c2);
    }

    static int _badChar(String string2, int n, char c) {
        throw new NumberFormatException("Non-hex character '" + c + "', not valid character for a UUID String" + "' (value 0x" + Integer.toHexString(c) + ") for UUID String \"" + string2 + "\"");
    }

    private UUID _fromBytes(byte[] byArray, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (byArray.length != 16) {
            deserializationContext.mappingException("Can only construct UUIDs from byte[16]; got " + byArray.length + " bytes");
        }
        return new UUID(UUIDDeserializer._long(byArray, 0), UUIDDeserializer._long(byArray, 8));
    }

    private static long _long(byte[] byArray, int n) {
        long l = (long)UUIDDeserializer._int(byArray, n) << 32;
        long l2 = UUIDDeserializer._int(byArray, n + 4);
        l2 = l2 << 32 >>> 32;
        return l | l2;
    }

    private static int _int(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static {
        int n;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (n = 0; n < 10; ++n) {
            UUIDDeserializer.HEX_DIGITS[48 + n] = n;
        }
        for (n = 0; n < 6; ++n) {
            UUIDDeserializer.HEX_DIGITS[97 + n] = 10 + n;
            UUIDDeserializer.HEX_DIGITS[65 + n] = 10 + n;
        }
        instance = new UUIDDeserializer();
    }
}

