/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected TypeBindings _bindings;
    protected final List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;
    protected AnnotatedMethod _anySetterMethod;
    protected Map<Object, AnnotatedMember> _injectables;
    protected Set<String> _ignoredPropertyNames;
    protected AnnotatedMethod _jsonValueMethod;
    protected AnnotatedMember _anyGetter;

    protected BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType2, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list2) {
        super(javaType2);
        this._config = mapperConfig;
        this._annotationIntrospector = mapperConfig == null ? null : mapperConfig.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list2;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        this(pOJOPropertiesCollector.getConfig(), pOJOPropertiesCollector.getType(), pOJOPropertiesCollector.getClassDef(), pOJOPropertiesCollector.getProperties());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        BasicBeanDescription basicBeanDescription = new BasicBeanDescription(pOJOPropertiesCollector);
        basicBeanDescription._anySetterMethod = pOJOPropertiesCollector.getAnySetterMethod();
        basicBeanDescription._ignoredPropertyNames = pOJOPropertiesCollector.getIgnoredPropertyNames();
        basicBeanDescription._injectables = pOJOPropertiesCollector.getInjectables();
        basicBeanDescription._jsonValueMethod = pOJOPropertiesCollector.getJsonValueMethod();
        return basicBeanDescription;
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        BasicBeanDescription basicBeanDescription = new BasicBeanDescription(pOJOPropertiesCollector);
        basicBeanDescription._jsonValueMethod = pOJOPropertiesCollector.getJsonValueMethod();
        basicBeanDescription._anyGetter = pOJOPropertiesCollector.getAnyGetter();
        return basicBeanDescription;
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType2, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType2, annotatedClass, Collections.<BeanPropertyDefinition>emptyList());
    }

    public boolean removeProperty(String string2) {
        Iterator<BeanPropertyDefinition> iterator2 = this._properties.iterator();
        while (iterator2.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator2.next();
            if (!beanPropertyDefinition.getName().equals(string2)) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties;
    }

    @Override
    public AnnotatedMethod findJsonValueMethod() {
        return this._jsonValueMethod;
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        if (this._ignoredPropertyNames == null) {
            return Collections.emptySet();
        }
        return this._ignoredPropertyNames;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    public TypeBindings bindingsForBeanType() {
        if (this._bindings == null) {
            this._bindings = new TypeBindings(this._config.getTypeFactory(), this._type);
        }
        return this._bindings;
    }

    @Override
    public JavaType resolveType(Type type) {
        if (type == null) {
            return null;
        }
        return this.bindingsForBeanType().resolveType(type);
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        Class<?> clazz2;
        if (this._anySetterMethod != null && (clazz2 = this._anySetterMethod.getRawParameterType(0)) != String.class && clazz2 != Object.class) {
            throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + this._anySetterMethod.getName() + "(): first argument not of type String or Object, but " + clazz2.getName());
        }
        return this._anySetterMethod;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        return this._injectables;
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public Object instantiateBean(boolean bl) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl) {
            annotatedConstructor.fixAccess();
        }
        try {
            return ((Constructor)annotatedConstructor.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable2 = exception;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable2.getClass().getName() + ") " + throwable2.getMessage(), throwable2);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string2, Class<?>[] classArray) {
        return this._classInfo.findMethod(string2, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value value2) {
        JsonFormat.Value value3;
        if (this._annotationIntrospector != null && (value3 = this._annotationIntrospector.findFormat(this._classInfo)) != null) {
            return value3;
        }
        return value2;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(JsonInclude.Include include) {
        if (this._annotationIntrospector == null) {
            return include;
        }
        return this._annotationIntrospector.findSerializationInclusion(this._classInfo, include);
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        Class<?> clazz2;
        if (this._anyGetter != null && !Map.class.isAssignableFrom(clazz2 = this._anyGetter.getRawType())) {
            throw new IllegalArgumentException("Invalid 'any-getter' annotation on method " + this._anyGetter.getName() + "(): return type is not instance of java.util.Map");
        }
        return this._anyGetter;
    }

    @Override
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        HashMap<String, AnnotatedMember> hashMap = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties) {
            String string2;
            AnnotationIntrospector.ReferenceProperty referenceProperty;
            AnnotatedMember annotatedMember = beanPropertyDefinition.getMutator();
            if (annotatedMember == null || (referenceProperty = this._annotationIntrospector.findReferenceType(annotatedMember)) == null || !referenceProperty.isBackReference()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, AnnotatedMember>();
            }
            if (hashMap.put(string2 = referenceProperty.getName(), annotatedMember) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + string2 + "'");
        }
        return hashMap;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> list2 = this._classInfo.getStaticMethods();
        if (list2.isEmpty()) {
            return list2;
        }
        ArrayList<AnnotatedMethod> arrayList = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod annotatedMethod : list2) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            arrayList.add(annotatedMethod);
        }
        return arrayList;
    }

    @Override
    public Constructor<?> findSingleArgConstructor(Class<?> ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : this._classInfo.getConstructors()) {
            if (annotatedConstructor.getParameterCount() != 1) continue;
            Class<?> clazz2 = annotatedConstructor.getRawParameterType(0);
            for (Class<?> clazz3 : classArray) {
                if (clazz3 != clazz2) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    @Override
    public Method findFactoryMethod(Class<?> ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getStaticMethods()) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            Class<?> clazz2 = annotatedMethod.getRawParameterType(0);
            for (Class<?> clazz3 : classArray) {
                if (!clazz2.isAssignableFrom(clazz3)) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz2;
        Class<?> clazz3 = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz3)) {
            return false;
        }
        if (this._annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            return true;
        }
        String string2 = annotatedMethod.getName();
        if ("valueOf".equals(string2)) {
            return true;
        }
        return "fromString".equals(string2) && 1 == annotatedMethod.getParameterCount() && ((clazz2 = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz2));
    }

    public List<String> findCreatorPropertyNames() {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < 2; ++i) {
            List<AnnotatedWithParams> list2 = i == 0 ? this.getConstructors() : this.getFactoryMethods();
            for (AnnotatedWithParams annotatedWithParams : list2) {
                PropertyName propertyName;
                int n = annotatedWithParams.getParameterCount();
                if (n < 1 || (propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedWithParams.getParameter(0))) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(propertyName.getSimpleName());
                for (int j = 1; j < n; ++j) {
                    propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedWithParams.getParameter(j));
                    arrayList.add(propertyName == null ? null : propertyName.getSimpleName());
                }
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(Collection<String> collection, boolean bl) {
        LinkedHashMap<String, AnnotatedField> linkedHashMap = new LinkedHashMap<String, AnnotatedField>();
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string2 = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string2)) continue;
            linkedHashMap.put(string2, annotatedField);
        }
        return linkedHashMap;
    }

    public Converter<Object, Object> _createConverter(Object object) {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == Converter.None.class || clazz2 == NoClass.class) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz2)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz2.getName() + "; expected Class<Converter>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(this._config, this._classInfo, clazz2);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz2, this._config.canOverrideAccessModifiers());
        }
        return converter;
    }
}

