/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(serializerFactoryConfig);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType javaType2) throws JsonMappingException {
        boolean bl;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        Object t = serializationConfig.introspect(javaType2);
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t).getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        JavaType javaType3 = this.modifyTypeByAnnotation(serializationConfig, ((BeanDescription)t).getClassInfo(), javaType2);
        if (javaType3 == javaType2) {
            bl = false;
        } else {
            bl = true;
            if (!javaType3.hasRawClass(javaType2.getRawClass())) {
                t = serializationConfig.introspect(javaType3);
            }
        }
        Converter<Object, Object> converter = ((BeanDescription)t).findSerializationConverter();
        if (converter == null) {
            return this._createSerializer2(serializerProvider, javaType3, (BeanDescription)t, bl);
        }
        JavaType javaType4 = converter.getOutputType(serializerProvider.getTypeFactory());
        if (!javaType4.hasRawClass(javaType3.getRawClass())) {
            t = serializationConfig.introspect(javaType4);
        }
        return new StdDelegatingSerializer(converter, javaType4, this._createSerializer2(serializerProvider, javaType4, (BeanDescription)t, true));
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType2, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this.findSerializerByAnnotations(serializerProvider, javaType2, beanDescription);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (javaType2.isContainerType()) {
            if (!bl) {
                bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
            }
            if ((jsonSerializer = this.buildContainerSerializer(serializerProvider, javaType2, beanDescription, bl)) != null) {
                return jsonSerializer;
            }
        } else {
            Serializers object;
            Iterator<Object> iterator2 = this.customSerializers().iterator();
            while (iterator2.hasNext() && (jsonSerializer = (object = iterator2.next()).findSerializer(serializationConfig, javaType2, beanDescription)) == null) {
            }
        }
        if (jsonSerializer == null && (jsonSerializer = this.findSerializerByLookup(javaType2, serializationConfig, beanDescription, bl)) == null && (jsonSerializer = this.findSerializerByPrimaryType(serializerProvider, javaType2, beanDescription, bl)) == null && (jsonSerializer = this.findBeanSerializer(serializerProvider, javaType2, beanDescription)) == null) {
            jsonSerializer = this.findSerializerByAddonType(serializationConfig, javaType2, beanDescription, bl);
        }
        if (jsonSerializer != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    @Deprecated
    public final JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType2, BeanDescription beanDescription, BeanProperty beanProperty) throws JsonMappingException {
        return this.findBeanSerializer(serializerProvider, javaType2, beanDescription);
    }

    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType2, BeanDescription beanDescription) throws JsonMappingException {
        if (!this.isPotentialBeanType(javaType2.getRawClass()) && !javaType2.isEnumType()) {
            return null;
        }
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    @Deprecated
    public final TypeSerializer findPropertyTypeSerializer(JavaType javaType2, SerializationConfig serializationConfig, AnnotatedMember annotatedMember, BeanProperty beanProperty) throws JsonMappingException {
        return this.findPropertyTypeSerializer(javaType2, serializationConfig, annotatedMember);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType javaType2, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(serializationConfig, annotatedMember, javaType2);
        if (typeResolverBuilder == null) {
            return this.createTypeSerializer(serializationConfig, javaType2);
        }
        Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, serializationConfig, annotationIntrospector, javaType2);
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType2, collection);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType javaType2, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        JavaType javaType3 = javaType2.getContentType();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(serializationConfig, annotatedMember, javaType2);
        if (typeResolverBuilder == null) {
            return this.createTypeSerializer(serializationConfig, javaType3);
        }
        Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, serializationConfig, annotationIntrospector, javaType3);
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType3, collection);
    }

    @Deprecated
    protected final JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanProperty beanProperty) throws JsonMappingException {
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        if (beanDescription.getBeanClass() == Object.class) {
            return serializerProvider.getUnknownTypeSerializer(Object.class);
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanSerializerBuilder beanSerializerBuilder = this.constructBeanSerializerBuilder(beanDescription);
        beanSerializerBuilder.setConfig(serializationConfig);
        List<BeanPropertyWriter> list2 = this.findBeanProperties(serializerProvider, beanDescription, beanSerializerBuilder);
        if (list2 == null) {
            list2 = new ArrayList<BeanPropertyWriter>();
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier object2 : this._factoryConfig.serializerModifiers()) {
                list2 = object2.changeProperties(serializationConfig, beanDescription, list2);
            }
        }
        list2 = this.filterBeanProperties(serializationConfig, beanDescription, list2);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                list2 = beanSerializerModifier.orderProperties(serializationConfig, beanDescription, list2);
            }
        }
        beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler(serializerProvider, beanDescription, list2));
        beanSerializerBuilder.setProperties(list2);
        beanSerializerBuilder.setFilterId(this.findFilterId(serializationConfig, beanDescription));
        AnnotatedMember annotatedMember = beanDescription.findAnyGetter();
        if (annotatedMember != null) {
            if (serializationConfig.canOverrideAccessModifiers()) {
                annotatedMember.fixAccess();
            }
            JavaType javaType2 = annotatedMember.getType(beanDescription.bindingsForBeanType());
            boolean bl = serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
            JavaType javaType3 = javaType2.getContentType();
            TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType3);
            MapSerializer mapSerializer = MapSerializer.construct(null, javaType2, bl, typeSerializer, null, null, null);
            PropertyName propertyName = new PropertyName(annotatedMember.getName());
            BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType3, null, beanDescription.getClassAnnotations(), annotatedMember, PropertyMetadata.STD_OPTIONAL);
            beanSerializerBuilder.setAnyGetter(new AnyGetterWriter(std, annotatedMember, mapSerializer));
        }
        this.processViews(serializationConfig, beanSerializerBuilder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                beanSerializerBuilder = beanSerializerModifier.updateBuilder(serializationConfig, beanDescription, beanSerializerBuilder);
            }
        }
        if ((jsonSerializer = beanSerializerBuilder.build()) == null && beanDescription.hasKnownClassAnnotations()) {
            return beanSerializerBuilder.createDummy();
        }
        return jsonSerializer;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider serializerProvider, BeanDescription beanDescription, List<BeanPropertyWriter> list2) throws JsonMappingException {
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz2 = objectIdInfo.getGeneratorType();
        if (clazz2 == ObjectIdGenerators.PropertyGenerator.class) {
            String string2 = objectIdInfo.getPropertyName().getSimpleName();
            BeanPropertyWriter beanPropertyWriter = null;
            int n = 0;
            int n2 = list2.size();
            while (true) {
                if (n == n2) {
                    throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + string2 + "'");
                }
                BeanPropertyWriter beanPropertyWriter2 = list2.get(n);
                if (string2.equals(beanPropertyWriter2.getName())) {
                    beanPropertyWriter = beanPropertyWriter2;
                    if (n <= 0) break;
                    list2.remove(n);
                    list2.add(0, beanPropertyWriter);
                    break;
                }
                ++n;
            }
            JavaType javaType2 = beanPropertyWriter.getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo, beanPropertyWriter);
            return ObjectIdWriter.construct(javaType2, (PropertyName)null, propertyBasedObjectIdGenerator, objectIdInfo.getAlwaysAsId());
        }
        JavaType javaType3 = serializerProvider.constructType(clazz2);
        JavaType javaType4 = serializerProvider.getTypeFactory().findTypeParameters(javaType3, ObjectIdGenerator.class)[0];
        ObjectIdGenerator<?> objectIdGenerator = serializerProvider.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct(javaType4, objectIdInfo.getPropertyName(), objectIdGenerator, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    protected boolean isPotentialBeanType(Class<?> clazz2) {
        return ClassUtil.canBeABeanType(clazz2) == null && !ClassUtil.isProxyType(clazz2);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list2 = beanDescription.findProperties();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        this.removeIgnorableTypes(serializationConfig, beanDescription, list2);
        if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(serializationConfig, beanDescription, list2);
        }
        if (list2.isEmpty()) {
            return null;
        }
        boolean bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
        PropertyBuilder propertyBuilder = this.constructPropertyBuilder(serializationConfig, beanDescription);
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(list2.size());
        TypeBindings typeBindings = beanDescription.bindingsForBeanType();
        for (BeanPropertyDefinition beanPropertyDefinition : list2) {
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                if (serializationConfig.canOverrideAccessModifiers()) {
                    annotatedMember.fixAccess();
                }
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, typeBindings, propertyBuilder, bl, (AnnotatedMethod)annotatedMember));
                continue;
            }
            arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, typeBindings, propertyBuilder, bl, (AnnotatedField)annotatedMember));
        }
        return arrayList;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list2) {
        AnnotatedClass annotatedClass;
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        String[] stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedClass = beanDescription.getClassInfo());
        if (stringArray != null && stringArray.length > 0) {
            HashSet<String> hashSet = ArrayBuilders.arrayToSet(stringArray);
            Iterator<BeanPropertyWriter> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                if (!hashSet.contains(iterator2.next().getName())) continue;
                iterator2.remove();
            }
        }
        return list2;
    }

    protected void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list2 = beanSerializerBuilder.getProperties();
        boolean bl = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n = list2.size();
        int n2 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n];
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = list2.get(i);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray == null) {
                if (!bl) continue;
                beanPropertyWriterArray[i] = beanPropertyWriter;
                continue;
            }
            ++n2;
            beanPropertyWriterArray[i] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
        }
        if (bl && n2 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    protected void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list2) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        HashMap hashMap = new HashMap();
        Iterator<BeanPropertyDefinition> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator2.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (annotatedMember == null) {
                iterator2.remove();
                continue;
            }
            Class<?> clazz2 = annotatedMember.getRawType();
            Boolean bl = (Boolean)hashMap.get(clazz2);
            if (bl == null) {
                BeanDescription beanDescription2 = serializationConfig.introspectClassAnnotations(clazz2);
                AnnotatedClass annotatedClass = beanDescription2.getClassInfo();
                bl = annotationIntrospector.isIgnorableType(annotatedClass);
                if (bl == null) {
                    bl = Boolean.FALSE;
                }
                hashMap.put(clazz2, bl);
            }
            if (!bl.booleanValue()) continue;
            iterator2.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list2) {
        Iterator<BeanPropertyDefinition> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator2.next();
            if (beanPropertyDefinition.couldDeserialize() || beanPropertyDefinition.isExplicitlyIncluded()) continue;
            iterator2.remove();
        }
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, TypeBindings typeBindings, PropertyBuilder propertyBuilder, boolean bl, AnnotatedMember annotatedMember) throws JsonMappingException {
        PropertyName propertyName = beanPropertyDefinition.getFullName();
        if (serializerProvider.canOverrideAccessModifiers()) {
            annotatedMember.fixAccess();
        }
        JavaType javaType2 = annotatedMember.getType(typeBindings);
        BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType2, beanPropertyDefinition.getWrapperName(), propertyBuilder.getClassAnnotations(), annotatedMember, beanPropertyDefinition.getMetadata());
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, std);
        TypeSerializer typeSerializer = null;
        if (ClassUtil.isCollectionMapOrArray(javaType2.getRawClass())) {
            typeSerializer = this.findPropertyContentTypeSerializer(javaType2, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer2 = this.findPropertyTypeSerializer(javaType2, serializerProvider.getConfig(), annotatedMember);
        BeanPropertyWriter beanPropertyWriter = propertyBuilder.buildWriter(serializerProvider, beanPropertyDefinition, javaType2, jsonSerializer, typeSerializer2, typeSerializer, annotatedMember, bl);
        return beanPropertyWriter;
    }
}

