/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Method _accessorMethod;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final boolean _forceTypeInformation;

    public JsonValueSerializer(Method method, JsonSerializer<Object> jsonSerializer) {
        super(Object.class);
        this._accessorMethod = method;
        this._valueSerializer = jsonSerializer;
        this._property = null;
        this._forceTypeInformation = true;
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl) {
        super(JsonValueSerializer._notNullClass(jsonValueSerializer.handledType()));
        this._accessorMethod = jsonValueSerializer._accessorMethod;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        this._forceTypeInformation = bl;
    }

    private static final Class<Object> _notNullClass(Class<?> clazz2) {
        return clazz2 == null ? Object.class : clazz2;
    }

    public JsonValueSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl) {
        if (this._property == beanProperty && this._valueSerializer == jsonSerializer && bl == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, jsonSerializer, bl);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            if (serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) || Modifier.isFinal(this._accessorMethod.getReturnType().getModifiers())) {
                JavaType javaType2 = serializerProvider.constructType(this._accessorMethod.getGenericReturnType());
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType2, this._property);
                boolean bl = this.isNaturalTypeWithStdHandling(javaType2.getRawClass(), jsonSerializer);
                return this.withResolved(beanProperty, jsonSerializer, bl);
            }
        } else {
            jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, beanProperty);
            return this.withResolved(beanProperty, jsonSerializer, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        try {
            Object object2 = this._accessorMethod.invoke(object, new Object[0]);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                Class<?> clazz2 = object2.getClass();
                jsonSerializer = serializerProvider.findTypedValueSerializer(clazz2, true, this._property);
            }
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable2 = exception;
            while (throwable2 instanceof InvocationTargetException && throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw JsonMappingException.wrapWithPath(throwable2, object, this._accessorMethod.getName() + "()");
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        Object object2 = null;
        try {
            object2 = this._accessorMethod.invoke(object, new Object[0]);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = serializerProvider.findValueSerializer(object2.getClass(), this._property);
            } else if (this._forceTypeInformation) {
                typeSerializer.writeTypePrefixForScalar(object, jsonGenerator);
                jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
                typeSerializer.writeTypeSuffixForScalar(object, jsonGenerator);
                return;
            }
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializer);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable2 = exception;
            while (throwable2 instanceof InvocationTargetException && throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw JsonMappingException.wrapWithPath(throwable2, object, this._accessorMethod.getName() + "()");
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._valueSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._valueSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType2) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            if (javaType2 == null) {
                if (this._property != null) {
                    javaType2 = this._property.getType();
                }
                if (javaType2 == null) {
                    javaType2 = jsonFormatVisitorWrapper.getProvider().constructType(this._accessorMethod.getReturnType());
                }
            }
            if ((jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer(javaType2, false, this._property)) == null) {
                jsonFormatVisitorWrapper.expectAnyFormat(javaType2);
                return;
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, null);
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> clazz2, JsonSerializer<?> jsonSerializer) {
        if (clazz2.isPrimitive() ? clazz2 != Integer.TYPE && clazz2 != Boolean.TYPE && clazz2 != Double.TYPE : clazz2 != String.class && clazz2 != Integer.class && clazz2 != Boolean.class && clazz2 != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessorMethod.getDeclaringClass() + "#" + this._accessorMethod.getName() + ")";
    }
}

