/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.MapProperty;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final HashSet<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Object _filterId;

    protected MapSerializer(HashSet<String> hashSet, JavaType javaType2, JavaType javaType3, boolean bl, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2) {
        super(Map.class, false);
        this._ignoredEntries = hashSet;
        this._keyType = javaType2;
        this._valueType = javaType3;
        this._valueTypeIsStatic = bl;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
        this._filterId = null;
    }

    protected MapSerializer(MapSerializer mapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, HashSet<String> hashSet) {
        super(Map.class, false);
        this._ignoredEntries = hashSet;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = beanProperty;
        this._filterId = mapSerializer._filterId;
    }

    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
        this._filterId = mapSerializer._filterId;
    }

    protected MapSerializer(MapSerializer mapSerializer, Object object) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
        this._filterId = object;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new MapSerializer(this, typeSerializer);
    }

    public MapSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, HashSet<String> hashSet) {
        return new MapSerializer(this, beanProperty, jsonSerializer, jsonSerializer2, hashSet);
    }

    public MapSerializer withFilterId(Object object) {
        return this._filterId == object ? this : new MapSerializer(this, object);
    }

    @Deprecated
    public static MapSerializer construct(String[] stringArray, JavaType javaType2, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2) {
        return MapSerializer.construct(stringArray, javaType2, bl, typeSerializer, jsonSerializer, jsonSerializer2, null);
    }

    public static MapSerializer construct(String[] stringArray, JavaType javaType2, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object) {
        JavaType javaType3;
        JavaType javaType4;
        HashSet<String> hashSet = MapSerializer.toSet(stringArray);
        if (javaType2 == null) {
            javaType3 = javaType4 = UNSPECIFIED_TYPE;
        } else {
            javaType3 = javaType2.getKeyType();
            javaType4 = javaType2.getContentType();
        }
        if (!bl) {
            bl = javaType4 != null && javaType4.isFinal();
        } else if (javaType4.getRawClass() == Object.class) {
            bl = false;
        }
        MapSerializer mapSerializer = new MapSerializer(hashSet, javaType3, javaType4, bl, typeSerializer, jsonSerializer, jsonSerializer2);
        if (object != null) {
            mapSerializer = mapSerializer.withFilterId(object);
        }
        return mapSerializer;
    }

    private static HashSet<String> toSet(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string2 : stringArray) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        JsonSerializer<Object> jsonSerializer = null;
        JsonSerializer<Object> jsonSerializer2 = null;
        if (beanProperty != null && (serializable = beanProperty.getMember()) != null) {
            object3 = serializerProvider.getAnnotationIntrospector();
            object2 = ((AnnotationIntrospector)object3).findKeySerializer((Annotated)((Object)serializable));
            if (object2 != null) {
                jsonSerializer2 = serializerProvider.serializerInstance((Annotated)((Object)serializable), object2);
            }
            if ((object2 = ((AnnotationIntrospector)object3).findContentSerializer((Annotated)((Object)serializable))) != null) {
                jsonSerializer = serializerProvider.serializerInstance((Annotated)((Object)serializable), object2);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            if (this._valueTypeIsStatic && this._valueType.getRawClass() != Object.class || this.hasContentTypeAnnotation(serializerProvider, beanProperty)) {
                jsonSerializer = serializerProvider.findValueSerializer(this._valueType, beanProperty);
            }
        } else {
            jsonSerializer = serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty);
        }
        if (jsonSerializer2 == null) {
            jsonSerializer2 = this._keySerializer;
        }
        jsonSerializer2 = jsonSerializer2 == null ? serializerProvider.findKeySerializer(this._keyType, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer2, beanProperty);
        serializable = this._ignoredEntries;
        object2 = serializerProvider.getAnnotationIntrospector();
        if (object2 != null && beanProperty != null && (object3 = ((AnnotationIntrospector)object2).findPropertiesToIgnore(beanProperty.getMember())) != null) {
            serializable = serializable == null ? new HashSet() : new HashSet(serializable);
            object = object3;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object[i];
                ((HashSet)serializable).add(object4);
            }
        }
        object3 = this.withResolved(beanProperty, jsonSerializer2, jsonSerializer, (HashSet<String>)serializable);
        if (beanProperty != null && (object = ((AnnotationIntrospector)object2).findFilterId(beanProperty.getMember())) != null) {
            object3 = ((MapSerializer)object3).withFilterId(object);
        }
        return object3;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> map2) {
        return map2.size() == 1;
    }

    public JsonSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        if (!map2.isEmpty()) {
            if (this._filterId != null) {
                this.serializeFilteredFields(map2, jsonGenerator, serializerProvider, this.findPropertyFilter(serializerProvider, this._filterId, map2));
                return;
            }
            if (serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map2 = this._orderEntries(map2);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map2, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map2, jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(map2, jsonGenerator);
        if (!map2.isEmpty()) {
            if (serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map2 = this._orderEntries(map2);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map2, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map2, jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForObject(map2, jsonGenerator);
    }

    public void serializeFields(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map2, jsonGenerator, serializerProvider);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        HashSet<String> hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
            Object obj = entry2.getValue();
            Object obj2 = entry2.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz2 = obj.getClass();
            JsonSerializer<Object> jsonSerializer2 = propertySerializerMap.serializerFor(clazz2);
            if (jsonSerializer2 == null) {
                jsonSerializer2 = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz2), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz2, serializerProvider);
                propertySerializerMap = this._dynamicValueSerializers;
            }
            try {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                String string2 = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map2, string2);
            }
        }
    }

    protected void serializeFieldsUsing(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        JsonSerializer<Object> jsonSerializer2 = this._keySerializer;
        HashSet<String> hashSet = this._ignoredEntries;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
            Object obj = entry2.getValue();
            Object obj2 = entry2.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer2.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                String string2 = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map2, string2);
            }
        }
    }

    public void serializeFilteredFields(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter) throws IOException, JsonGenerationException {
        HashSet<String> hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        MapProperty mapProperty = new MapProperty(this._valueTypeSerializer);
        for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            JsonSerializer<Object> jsonSerializer2;
            Object obj = entry2.getKey();
            Object obj2 = entry2.getValue();
            if (obj == null) {
                jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (bl && obj2 == null || hashSet != null && hashSet.contains(obj)) continue;
                jsonSerializer2 = this._keySerializer;
            }
            if (obj2 == null) {
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                Class<?> clazz2 = obj2.getClass();
                jsonSerializer = propertySerializerMap.serializerFor(clazz2);
                if (jsonSerializer == null) {
                    jsonSerializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz2), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz2, serializerProvider);
                    propertySerializerMap = this._dynamicValueSerializers;
                }
            }
            mapProperty.reset(obj, obj2, jsonSerializer2, jsonSerializer);
            try {
                propertyFilter.serializeAsField(map2, jsonGenerator, serializerProvider, mapProperty);
            }
            catch (Exception exception) {
                String string2 = "" + obj;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map2, string2);
            }
        }
    }

    protected void serializeTypedFields(Map<?, ?> map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        JsonSerializer<Object> jsonSerializer2 = null;
        Class<?> clazz2 = null;
        HashSet<String> hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
            JsonSerializer<Object> jsonSerializer3;
            Object obj = entry2.getValue();
            Object obj2 = entry2.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz3 = obj.getClass();
            if (clazz3 == clazz2) {
                jsonSerializer3 = jsonSerializer2;
            } else {
                jsonSerializer3 = this._valueType.hasGenericTypes() ? serializerProvider.findValueSerializer(serializerProvider.constructSpecializedType(this._valueType, clazz3), this._property) : serializerProvider.findValueSerializer(clazz3, this._property);
                jsonSerializer2 = jsonSerializer3;
                clazz2 = clazz3;
            }
            try {
                jsonSerializer3.serializeWithType(obj, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            }
            catch (Exception exception) {
                String string2 = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map2, string2);
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("object", true);
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType2) throws JsonMappingException {
        JsonMapFormatVisitor jsonMapFormatVisitor;
        JsonMapFormatVisitor jsonMapFormatVisitor2 = jsonMapFormatVisitor = jsonFormatVisitorWrapper == null ? null : jsonFormatVisitorWrapper.expectMapFormat(javaType2);
        if (jsonMapFormatVisitor != null) {
            jsonMapFormatVisitor.keyFormat(this._keySerializer, this._keyType);
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(this._dynamicValueSerializers, this._valueType, jsonFormatVisitorWrapper.getProvider());
            }
            jsonMapFormatVisitor.valueFormat(jsonSerializer, this._valueType);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz2, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(clazz2, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType2, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(javaType2, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> map2) {
        if (map2 instanceof SortedMap) {
            return map2;
        }
        return new TreeMap(map2);
    }
}

