/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.concurrent;

import com.twitter.concurrent.AbstractOffer;
import com.twitter.concurrent.Offer;
import com.twitter.concurrent.Offer$;
import com.twitter.concurrent.Tx;
import com.twitter.concurrent.Txs;
import com.twitter.util.Duration;
import com.twitter.util.Function0;
import com.twitter.util.Future;
import com.twitter.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import scala.collection.JavaConversions;
import scala.runtime.BoxedUnit;

public final class Offers {
    public static final Offer<?> NEVER = Offer$.MODULE$.never();

    private Offers() {
    }

    public static <T> Offer<T> newConstOffer(final Function0<T> function0) {
        return new AbstractOffer<T>(){

            @Override
            public Future<Tx<T>> prepare() {
                return Future.value(Txs.newConstTx(function0.apply()));
            }
        };
    }

    public static <T> Offer<T> newConstOffer(final T t) {
        return Offers.newConstOffer(new Function0<T>(){

            @Override
            public T apply() {
                return t;
            }
        });
    }

    public static Offer<BoxedUnit> newTimeoutOffer(Duration duration, Timer timer) {
        return Offer$.MODULE$.timeout(duration, timer);
    }

    public static <T> Offer<T> choose(Collection<Offer<T>> collection) {
        return Offer$.MODULE$.choose(JavaConversions.asScalaBuffer(new ArrayList<Offer<T>>(collection)));
    }

    public static <T> Future<T> select(Collection<Offer<T>> collection) {
        return Offers.choose(collection).sync();
    }
}

