'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = runMetarpheusTcomb;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _child_process = require('child_process');

var _metarpheusTcomb2 = require('metarpheus-tcomb');

var _metarpheusTcomb3 = _interopRequireDefault(_metarpheusTcomb2);

var _util = require('../../util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function buildCmdForLogging(cmd) {
  return [' \n '].concat(cmd).join(' \n ').concat([' \n \n ']);
}

function buildCmdForExecuting(cmd) {
  return cmd.join(' \ ');
}

// RUN METARPHEUS
function runMetarpheusTcomb(metarpheusTcombConfig) {

  var cwd = process.cwd();

  // define user scala configuration (usc) file path
  var uscFilePath = _path2.default.resolve(cwd, './metarpheus-config.scala');
  // set config (cfg) to usc file path if exists, otherwise fallback on default config
  var defaultScalaConfig = _path2.default.resolve(__dirname, '../../../src/scripts/metarpheus/config.scala'); // eslint-disable-line max-len
  // TODO: fs.existsSync is deprecated
  var cfg = _fs2.default.existsSync(uscFilePath) && uscFilePath || defaultScalaConfig;
  _util.logger.metarpheus('Using scala config: ' + cfg);
  // define output (otp) file path
  var otp = metarpheusTcombConfig.intermRepIn;
  var apiPath = metarpheusTcombConfig.apiPath;
  // compose metarpheus command

  var metarpheusJar = _path2.default.resolve(__dirname, 'metarpheus.jar');
  var metarpheusCmd = ['java', '-jar ' + metarpheusJar, '--config=' + cfg, '--output=' + otp, '' + apiPath];

  // exec cmd syncronously
  _util.logger.metarpheus('Starting ' + buildCmdForLogging(metarpheusCmd));
  (0, _child_process.execSync)(buildCmdForExecuting(metarpheusCmd));
  _util.logger.metarpheus('Finished ' + buildCmdForLogging(metarpheusCmd));

  // METARPHEUS-TCOMB
  _util.logger.metarpheus('Starting metarpheus-tcomb');
  var overrides = metarpheusTcombConfig.overrides,
      modelPrelude = metarpheusTcombConfig.modelPrelude,
      apiPrelude = metarpheusTcombConfig.apiPrelude,
      apiModelPrefix = metarpheusTcombConfig.apiModelPrefix,
      renameModel = metarpheusTcombConfig.renameModel,
      intermRepIn = metarpheusTcombConfig.intermRepIn;
  // use metarpheus-tcomb node api to generate model and api

  var _metarpheusTcomb = (0, _metarpheusTcomb3.default)({
    intermRep: require(intermRepIn),
    config: {
      overrides: overrides,
      modelPrelude: modelPrelude,
      apiPrelude: apiPrelude,
      apiModelPrefix: apiModelPrefix,
      renameModel: renameModel
    }
  }),
      model = _metarpheusTcomb.model,
      api = _metarpheusTcomb.api;

  _util.logger.metarpheus('Finished metarpheus-tcomb');
  return { model: model, api: api };
}