'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _stylelint = require('stylelint');

var _chalk = require('chalk');

var _util = require('../../util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cwd = process.cwd();

function readConfigInDir(dir) {
  var stylelintrc = _path2.default.resolve(dir, '.stylelintrc');
  return _fs2.default.existsSync(stylelintrc) && JSON.parse(_fs2.default.readFileSync(stylelintrc));
}

function getConfig() {
  var defaultStylelintrc = readConfigInDir((0, _util.resolveInSrc)('stylelint'));
  var userStylelintrc = readConfigInDir(cwd);

  return {
    config: _extends({}, defaultStylelintrc, userStylelintrc || {}),
    configBasedir: userStylelintrc ? cwd : '../../../'
  };
}

var options = _extends({}, getConfig(), {
  files: _path2.default.resolve(cwd, 'src/**/*.scss'),
  syntax: 'scss',
  formatter: 'string'
});

(0, _stylelint.lint)(options).then(function (_ref) {
  var output = _ref.output;
  return console.log(output);
}) // eslint-disable-line no-console
.catch(function (err) {
  return console.log((0, _chalk.red)(err.stack));
}); // eslint-disable-line no-console