/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.Writer;

public final class SegmentedStringWriter
extends Writer {
    protected final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler bufferRecycler) {
        this._buffer = new TextBuffer(bufferRecycler);
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string2 = charSequence.toString();
        this._buffer.append(string2, 0, string2.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        String string2 = charSequence.subSequence(n, n2).toString();
        this._buffer.append(string2, 0, string2.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray) {
        this._buffer.append(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this._buffer.append(cArray, n, n2);
    }

    @Override
    public void write(int n) {
        this._buffer.append((char)n);
    }

    @Override
    public void write(String string2) {
        this._buffer.append(string2, 0, string2.length());
    }

    @Override
    public void write(String string2, int n, int n2) {
        this._buffer.append(string2, n, n2);
    }

    public String getAndClear() {
        String string2 = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return string2;
    }
}

