/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    Object writeReplace() {
        this._incompleteDeserializers.clear();
        return this;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType2);
        if (jsonDeserializer == null && (jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType2)) == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(javaType2);
        }
        return jsonDeserializer;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        KeyDeserializer keyDeserializer = deserializerFactory.createKeyDeserializer(deserializationContext, javaType2);
        if (keyDeserializer == null) {
            return this._handleUnknownKeyDeserializer(javaType2);
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(deserializationContext);
        }
        return keyDeserializer;
    }

    public boolean hasValueDeserializerFor(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType2);
        if (jsonDeserializer == null) {
            jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType2);
        }
        return jsonDeserializer != null;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType javaType2) {
        if (javaType2 == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        return this._cachedDeserializers.get(javaType2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> jsonDeserializer2 = this._findCachedDeserializer(javaType2);
                if (jsonDeserializer2 != null) {
                    return jsonDeserializer2;
                }
                int n = this._incompleteDeserializers.size();
                if (n > 0 && (jsonDeserializer2 = this._incompleteDeserializers.get(javaType2)) != null) {
                    return jsonDeserializer2;
                }
                try {
                    jsonDeserializer = this._createAndCache2(deserializationContext, deserializerFactory, javaType2);
                    if (n != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable2) {
                    if (n == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable2;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        try {
            jsonDeserializer = this._createDeserializer(deserializationContext, deserializerFactory, javaType2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonDeserializer == null) {
            return null;
        }
        boolean bl = jsonDeserializer instanceof ResolvableDeserializer;
        boolean bl2 = jsonDeserializer.isCachable();
        if (bl) {
            this._incompleteDeserializers.put(javaType2, jsonDeserializer);
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(deserializationContext);
            this._incompleteDeserializers.remove(javaType2);
        }
        if (bl2) {
            this._cachedDeserializers.put(javaType2, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2) throws JsonMappingException {
        Class<?> clazz2;
        Object t;
        JsonDeserializer<Object> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType2.isAbstract() || javaType2.isMapLikeType() || javaType2.isCollectionLikeType()) {
            javaType2 = deserializerFactory.mapAbstractType(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)(t = deserializationConfig.introspect(javaType2))).getClassInfo())) != null) {
            return jsonDeserializer;
        }
        JavaType javaType3 = this.modifyTypeByAnnotation(deserializationContext, ((BeanDescription)t).getClassInfo(), javaType2);
        if (javaType3 != javaType2) {
            javaType2 = javaType3;
            t = deserializationConfig.introspect(javaType3);
        }
        if ((clazz2 = ((BeanDescription)t).findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, javaType2, (BeanDescription)t, clazz2);
        }
        Converter<Object, Object> converter = ((BeanDescription)t).findDeserializationConverter();
        if (converter == null) {
            return this._createDeserializer2(deserializationContext, deserializerFactory, javaType2, (BeanDescription)t);
        }
        JavaType javaType4 = converter.getInputType(deserializationContext.getTypeFactory());
        if (!javaType4.hasRawClass(javaType2.getRawClass())) {
            t = deserializationConfig.introspect(javaType4);
        }
        return new StdDelegatingDeserializer<Object>(converter, javaType4, this._createDeserializer2(deserializationContext, deserializerFactory, javaType4, (BeanDescription)t));
    }

    protected JsonDeserializer<?> _createDeserializer2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType2, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType2.isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType2, beanDescription);
        }
        if (javaType2.isContainerType()) {
            JsonFormat.Value value2;
            if (javaType2.isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType2, beanDescription);
            }
            if (javaType2.isMapLikeType()) {
                MapLikeType mapLikeType = (MapLikeType)javaType2;
                if (mapLikeType.isTrueMapType()) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)mapLikeType, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, mapLikeType, beanDescription);
            }
            if (javaType2.isCollectionLikeType() && ((value2 = beanDescription.findExpectedFormat(null)) == null || value2.getShape() != JsonFormat.Shape.OBJECT)) {
                CollectionLikeType collectionLikeType = (CollectionLikeType)javaType2;
                if (collectionLikeType.isTrueCollectionType()) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)collectionLikeType, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, collectionLikeType, beanDescription);
            }
        }
        if (JsonNode.class.isAssignableFrom(javaType2.getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType2, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType2, beanDescription);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializer(annotated);
        if (object == null) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = deserializationContext.deserializerInstance(annotated, object);
        return this.findConvertingDeserializer(deserializationContext, annotated, jsonDeserializer);
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext deserializationContext, Annotated annotated, JsonDeserializer<Object> jsonDeserializer) throws JsonMappingException {
        Converter<Object, Object> converter = this.findConverter(deserializationContext, annotated);
        if (converter == null) {
            return jsonDeserializer;
        }
        JavaType javaType2 = converter.getInputType(deserializationContext.getTypeFactory());
        return new StdDelegatingDeserializer<Object>(converter, javaType2, jsonDeserializer);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.converterInstance(annotated, object);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType2) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        Class<?> clazz2 = annotationIntrospector.findDeserializationType(annotated, javaType2);
        if (clazz2 != null) {
            try {
                javaType2 = javaType2.narrowBy(clazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException("Failed to narrow type " + javaType2 + " with concrete-type annotation (value " + clazz2.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage(), null, illegalArgumentException);
            }
        }
        if (javaType2.isContainerType()) {
            Object object;
            Object object2;
            Object object3;
            JavaType javaType3;
            Class<?> clazz3 = annotationIntrospector.findDeserializationKeyType(annotated, javaType2.getKeyType());
            if (clazz3 != null) {
                if (!(javaType2 instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + javaType2 + " is not a Map(-like) type");
                }
                try {
                    javaType2 = ((MapLikeType)javaType2).narrowKey(clazz3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow key type " + javaType2 + " with key-type annotation (" + clazz3.getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if ((javaType3 = javaType2.getKeyType()) != null && javaType3.getValueHandler() == null && (object3 = annotationIntrospector.findKeyDeserializer(annotated)) != null && (object2 = deserializationContext.keyDeserializerInstance(annotated, object3)) != null) {
                javaType2 = ((MapLikeType)javaType2).withKeyValueHandler(object2);
                javaType3 = javaType2.getKeyType();
            }
            if ((object3 = annotationIntrospector.findDeserializationContentType(annotated, javaType2.getContentType())) != null) {
                try {
                    javaType2 = javaType2.narrowContentsBy((Class<?>)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow content type " + javaType2 + " with content-type annotation (" + ((Class)object3).getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if (((JavaType)(object2 = javaType2.getContentType())).getValueHandler() == null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
                JsonDeserializer<Object> jsonDeserializer = null;
                if (object instanceof JsonDeserializer) {
                    object = (JsonDeserializer)object;
                } else {
                    Class<?> clazz4 = this._verifyAsClass(object, "findContentDeserializer", JsonDeserializer.None.class);
                    if (clazz4 != null) {
                        jsonDeserializer = deserializationContext.deserializerInstance(annotated, clazz4);
                    }
                }
                if (jsonDeserializer != null) {
                    javaType2 = javaType2.withContentValueHandler(jsonDeserializer);
                }
            }
        }
        return javaType2;
    }

    private Class<?> _verifyAsClass(Object object, String string2, Class<?> clazz2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string2 + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz3 = (Class)object;
        if (clazz3 == clazz2 || clazz3 == NoClass.class) {
            return null;
        }
        return clazz3;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType javaType2) throws JsonMappingException {
        Class<?> clazz2 = javaType2.getRawClass();
        if (!ClassUtil.isConcrete(clazz2)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + javaType2);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + javaType2);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType javaType2) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + javaType2);
    }
}

