/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz2, String string2) {
        if (!_classNames.contains(string2)) {
            return null;
        }
        if (clazz2 == Calendar.class) {
            return CalendarDeserializer.instance;
        }
        if (clazz2 == java.util.Date.class) {
            return DateDeserializer.instance;
        }
        if (clazz2 == Date.class) {
            return SqlDateDeserializer.instance;
        }
        if (clazz2 == Timestamp.class) {
            return TimestampDeserializer.instance;
        }
        if (clazz2 == TimeZone.class) {
            return TimeZoneDeserializer.instance;
        }
        if (clazz2 == GregorianCalendar.class) {
            return CalendarDeserializer.gregorianInstance;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + string2);
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz2 : classArray = new Class[]{Calendar.class, GregorianCalendar.class, Date.class, java.util.Date.class, Timestamp.class, TimeZone.class}) {
            _classNames.add(clazz2.getName());
        }
    }

    protected static class TimeZoneDeserializer
    extends FromStringDeserializer<TimeZone> {
        public static final TimeZoneDeserializer instance = new TimeZoneDeserializer();

        public TimeZoneDeserializer() {
            super(TimeZone.class);
        }

        @Override
        protected TimeZone _deserialize(String string2, DeserializationContext deserializationContext) throws IOException {
            return TimeZone.getTimeZone(string2);
        }
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public static final TimestampDeserializer instance = new TimestampDeserializer();

        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string2) {
            super(timestampDeserializer, dateFormat, string2);
        }

        protected TimestampDeserializer withDateFormat(DateFormat dateFormat, String string2) {
            return new TimestampDeserializer(this, dateFormat, string2);
        }

        @Override
        public Timestamp deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new Timestamp(this._parseDate(jsonParser, deserializationContext).getTime());
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public static final SqlDateDeserializer instance = new SqlDateDeserializer();

        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string2) {
            super(sqlDateDeserializer, dateFormat, string2);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string2) {
            return new SqlDateDeserializer(this, dateFormat, string2);
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            return date == null ? null : new Date(date.getTime());
        }
    }

    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string2) {
            super(dateDeserializer, dateFormat, string2);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string2) {
            return new DateDeserializer(this, dateFormat, string2);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        public static final CalendarDeserializer instance = new CalendarDeserializer();
        public static final CalendarDeserializer gregorianInstance = new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
        protected final Class<? extends Calendar> _calendarClass;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._calendarClass = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz2) {
            super(clazz2);
            this._calendarClass = clazz2;
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string2) {
            super(calendarDeserializer, dateFormat, string2);
            this._calendarClass = calendarDeserializer._calendarClass;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string2) {
            return new CalendarDeserializer(this, dateFormat, string2);
        }

        @Override
        public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            if (this._calendarClass == null) {
                return deserializationContext.constructCalendar(date);
            }
            try {
                Calendar calendar = this._calendarClass.newInstance();
                calendar.setTimeInMillis(date.getTime());
                TimeZone timeZone = deserializationContext.getTimeZone();
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                return calendar;
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._calendarClass, exception);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz2) {
            super(clazz2);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string2) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string2;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonFormat.Value value2;
            if (beanProperty != null && (value2 = deserializationContext.getAnnotationIntrospector().findFormat(beanProperty.getMember())) != null) {
                TimeZone timeZone = value2.getTimeZone();
                String string2 = value2.getPattern();
                if (string2.length() > 0) {
                    Locale locale = value2.getLocale();
                    if (locale == null) {
                        locale = deserializationContext.getLocale();
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                    if (timeZone == null) {
                        timeZone = deserializationContext.getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    return this.withDateFormat(simpleDateFormat, string2);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        dateFormat = ((StdDateFormat)dateFormat).withTimeZone(timeZone);
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                    }
                    return this.withDateFormat(dateFormat, string2);
                }
            }
            return this;
        }

        @Override
        protected java.util.Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (this._customFormat != null && jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                String string2 = jsonParser.getText().trim();
                if (string2.length() == 0) {
                    return (java.util.Date)this.getEmptyValue();
                }
                DateFormat dateFormat = this._customFormat;
                synchronized (dateFormat) {
                    try {
                        return this._customFormat.parse(string2);
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException("Failed to parse Date value '" + string2 + "' (format: \"" + this._formatString + "\"): " + parseException.getMessage());
                    }
                }
            }
            return super._parseDate(jsonParser, deserializationContext);
        }
    }
}

