/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.exc;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class PropertyBindingException
extends JsonMappingException {
    protected final Class<?> _referringClass;
    protected final String _propertyName;
    protected final Collection<Object> _propertyIds;
    protected transient String _propertiesAsString;
    private static final int MAX_DESC_LENGTH = 200;

    protected PropertyBindingException(String string2, JsonLocation jsonLocation, Class<?> clazz2, String string3, Collection<Object> collection) {
        super(string2, jsonLocation);
        this._referringClass = clazz2;
        this._propertyName = string3;
        this._propertyIds = collection;
    }

    @Override
    public String getMessageSuffix() {
        String string2 = this._propertiesAsString;
        if (string2 == null && this._propertyIds != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n = this._propertyIds.size();
            if (n == 1) {
                stringBuilder.append(" (one known property: \"");
                stringBuilder.append(String.valueOf(this._propertyIds.iterator().next()));
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(" (").append(n).append(" known properties: ");
                Iterator<Object> iterator2 = this._propertyIds.iterator();
                while (iterator2.hasNext()) {
                    stringBuilder.append('\"');
                    stringBuilder.append(String.valueOf(iterator2.next()));
                    stringBuilder.append('\"');
                    if (stringBuilder.length() > 200) {
                        stringBuilder.append(" [truncated]");
                        break;
                    }
                    if (!iterator2.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append("])");
            this._propertiesAsString = string2 = stringBuilder.toString();
        }
        return string2;
    }

    public Class<?> getReferringClass() {
        return this._referringClass;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Collection<Object> getKnownPropertyIds() {
        if (this._propertyIds == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this._propertyIds);
    }
}

