/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.Serializable;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    public static final BasicClassIntrospector instance;

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType2);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType2, mixInResolver, true, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType2);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType2, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType2, mixInResolver, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType2);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType2, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType2.getRawClass(), bl ? mapperConfig.getAnnotationIntrospector() : null, mixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType2, annotatedClass);
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(javaType2.getRawClass(), bl ? annotationIntrospector : null, mixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType2, annotatedClass);
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver, boolean bl, String string2) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType2.getRawClass(), bl2 ? mapperConfig.getAnnotationIntrospector() : null, mixInResolver);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType2, bl, string2).collect();
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType2, ClassIntrospector.MixInResolver mixInResolver, boolean bl) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = bl2 ? mapperConfig.getAnnotationIntrospector() : null;
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType2.getRawClass(), annotationIntrospector, mixInResolver);
        JsonPOJOBuilder.Value value2 = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
        String string2 = value2 == null ? "with" : value2.withPrefix;
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType2, bl, string2).collect();
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType2, boolean bl, String string2) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType2, annotatedClass, string2);
    }

    protected BasicBeanDescription _findCachedDesc(JavaType javaType2) {
        Class<?> clazz2 = javaType2.getRawClass();
        if (clazz2 == String.class) {
            return STRING_DESC;
        }
        if (clazz2 == Boolean.TYPE) {
            return BOOLEAN_DESC;
        }
        if (clazz2 == Integer.TYPE) {
            return INT_DESC;
        }
        if (clazz2 == Long.TYPE) {
            return LONG_DESC;
        }
        return null;
    }

    static {
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(String.class, null, null);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Boolean.TYPE, null, null);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Integer.TYPE, null, null);
        INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Long.TYPE, null, null);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), annotatedClass);
        instance = new BasicClassIntrospector();
    }
}

