/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;

public class PropertyBuilder {
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final JsonInclude.Include _outputProps;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        this._config = serializationConfig;
        this._beanDesc = beanDescription;
        this._outputProps = beanDescription.findSerializationInclusion(serializationConfig.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    @Deprecated
    protected final BeanPropertyWriter buildWriter(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType2, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) {
        throw new IllegalStateException();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType2, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) throws JsonMappingException {
        NameTransformer nameTransformer;
        Object object;
        JavaType javaType3 = this.findSerializationType(annotatedMember, bl, javaType2);
        if (typeSerializer2 != null) {
            if (javaType3 == null) {
                javaType3 = javaType2;
            }
            if ((object = javaType3.getContentType()) == null) {
                throw new IllegalStateException("Problem trying to create BeanPropertyWriter for property '" + beanPropertyDefinition.getName() + "' (of type " + this._beanDesc.getType() + "); serialization type " + javaType3 + " has no content");
            }
            javaType3 = javaType3.withContentTypeHandler(typeSerializer2);
            object = javaType3.getContentType();
        }
        object = null;
        boolean bl2 = false;
        JsonInclude.Include include = this._annotationIntrospector.findSerializationInclusion(annotatedMember, this._outputProps);
        if (include != null) {
            switch (include) {
                case NON_DEFAULT: {
                    object = this.getDefaultValue(beanPropertyDefinition.getName(), annotatedMember);
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    if (!object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                    break;
                }
                case NON_NULL: {
                    bl2 = true;
                }
                case ALWAYS: {
                    if (!javaType2.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                }
            }
        }
        BeanPropertyWriter beanPropertyWriter = new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, this._beanDesc.getClassAnnotations(), javaType2, jsonSerializer, typeSerializer, javaType3, bl2, object);
        Object object2 = this._annotationIntrospector.findNullSerializer(annotatedMember);
        if (object2 != null) {
            beanPropertyWriter.assignNullSerializer(serializerProvider.serializerInstance(annotatedMember, object2));
        }
        if ((nameTransformer = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember)) != null) {
            beanPropertyWriter = beanPropertyWriter.unwrappingWriter(nameTransformer);
        }
        return beanPropertyWriter;
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl, JavaType type) {
        JsonSerialize.Typing typing;
        Type type2;
        Class<?> clazz2 = this._annotationIntrospector.findSerializationType(annotated);
        if (clazz2 != null) {
            type2 = type.getRawClass();
            if (clazz2.isAssignableFrom((Class<?>)type2)) {
                type = type.widenBy(clazz2);
            } else {
                if (!((Class)type2).isAssignableFrom(clazz2)) {
                    throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + clazz2.getName() + " not a super-type of (declared) class " + ((Class)type2).getName());
                }
                type = this._config.constructSpecializedType((JavaType)type, clazz2);
            }
            bl = true;
        }
        if ((type2 = BeanSerializerFactory.modifySecondaryTypesByAnnotation(this._config, annotated, type)) != type) {
            bl = true;
            type = type2;
        }
        if ((typing = this._annotationIntrospector.findSerializationTyping(annotated)) != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            bl = typing == JsonSerialize.Typing.STATIC;
        }
        return bl ? type : null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (this._defaultBean == null) {
                AnnotatedElement annotatedElement = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)annotatedElement).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String string2, AnnotatedMember annotatedMember) {
        Object object = this.getDefaultBean();
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string2, object);
        }
    }

    protected Object _throwWrapped(Exception exception, String string2, Object object) {
        Throwable throwable2 = exception;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw new IllegalArgumentException("Failed to get property '" + string2 + "' of default " + object.getClass().getName() + " instance");
    }
}

