/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>>
implements ContextualSerializer {
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();
    protected final JsonSerializer<String> _serializer;

    protected IndexedStringListSerializer() {
        this((JsonSerializer<?>)null);
    }

    public IndexedStringListSerializer(JsonSerializer<?> jsonSerializer) {
        super(List.class);
        this._serializer = jsonSerializer;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor jsonArrayFormatVisitor) throws JsonMappingException {
        jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._serializer;
        }
        if (this.isDefaultSerializer(jsonSerializer = (jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null ? serializerProvider.findValueSerializer(String.class, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty))) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._serializer) {
            return this;
        }
        return new IndexedStringListSerializer(jsonSerializer);
    }

    @Override
    public void serialize(List<String> list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n = list2.size();
        if (n == 1 && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) {
            this._serializeUnwrapped(list2, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        if (this._serializer == null) {
            this.serializeContents(list2, jsonGenerator, serializerProvider, n);
        } else {
            this.serializeUsingCustom(list2, jsonGenerator, serializerProvider, n);
        }
        jsonGenerator.writeEndArray();
    }

    private final void _serializeUnwrapped(List<String> list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._serializer == null) {
            this.serializeContents(list2, jsonGenerator, serializerProvider, 1);
        } else {
            this.serializeUsingCustom(list2, jsonGenerator, serializerProvider, 1);
        }
    }

    @Override
    public void serializeWithType(List<String> list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        int n = list2.size();
        typeSerializer.writeTypePrefixForArray(list2, jsonGenerator);
        if (this._serializer == null) {
            this.serializeContents(list2, jsonGenerator, serializerProvider, n);
        } else {
            this.serializeUsingCustom(list2, jsonGenerator, serializerProvider, n);
        }
        typeSerializer.writeTypeSuffixForArray(list2, jsonGenerator);
    }

    private final void serializeContents(List<String> list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, int n) throws IOException, JsonGenerationException {
        int n2;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                String string2 = list2.get(n2);
                if (string2 == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonGenerator.writeString(string2);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list2, n2);
        }
    }

    private final void serializeUsingCustom(List<String> list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, int n) throws IOException, JsonGenerationException {
        int n2 = 0;
        try {
            JsonSerializer<String> jsonSerializer = this._serializer;
            for (n2 = 0; n2 < n; ++n2) {
                String string2 = list2.get(n2);
                if (string2 == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonSerializer.serialize(string2, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list2, n2);
        }
    }
}

