/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.lang.reflect.Type;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> clazz2, Converter<T, ?> converter) {
        super(clazz2, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType javaType2, JsonSerializer<?> jsonSerializer) {
        super(javaType2);
        this._converter = converter;
        this._delegateType = javaType2;
        this._delegateSerializer = jsonSerializer;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType javaType2, JsonSerializer<?> jsonSerializer) {
        if (this.getClass() != StdDelegatingSerializer.class) {
            throw new IllegalStateException("Sub-class " + this.getClass().getName() + " must override 'withDelegate'");
        }
        return new StdDelegatingSerializer(converter, javaType2, jsonSerializer);
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this._delegateSerializer != null && this._delegateSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this._delegateSerializer)).resolve(serializerProvider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (this._delegateSerializer != null) {
            if (this._delegateSerializer instanceof ContextualSerializer) {
                JsonSerializer<?> jsonSerializer = serializerProvider.handleSecondaryContextualization(this._delegateSerializer, beanProperty);
                if (jsonSerializer == this._delegateSerializer) {
                    return this;
                }
                return this.withDelegate(this._converter, this._delegateType, jsonSerializer);
            }
            return this;
        }
        JavaType javaType2 = this._delegateType;
        if (javaType2 == null) {
            javaType2 = this._converter.getOutputType(serializerProvider.getTypeFactory());
        }
        return this.withDelegate(this._converter, javaType2, serializerProvider.findValueSerializer(javaType2, beanProperty));
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        Object object2 = this.convertValue(object);
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        this._delegateSerializer.serialize(object2, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        Object object2 = this.convertValue(object);
        this._delegateSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public boolean isEmpty(Object object) {
        Object object2 = this.convertValue(object);
        return this._delegateSerializer.isEmpty(object2);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(serializerProvider, type);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(serializerProvider, type, bl);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType2) throws JsonMappingException {
        this._delegateSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType2);
    }

    protected Object convertValue(Object object) {
        return this._converter.convert(object);
    }
}

